// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.PopupControl;

/// <summary>
/// Simple PopupControl
/// </summary>
/// <TestSuite>
///   <Path>PopupControl\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PopupControlBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.PopupControl.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("PopupControl.Simple")]
public class PopupControl_Simple : AjaxControlToolkit.Testing.Client.PopupControl.PopupControl_Common
{
    public override IEnumerable<PopupControlScenario> PopupControlScenarios
    {
        get
        {
            SimplePage page = new SimplePage();
            yield return new PopupControlScenario(page.PopupControl, page.Panel, page.Commit, page.Clear, page.Cancel, page.CommitCancel, page.CancelCommit);
        }
    }

    [WebTestMethod]
    [WebTestTag("Smoke")]
    public override void Common_Commit()
    {
        base.Common_Commit();
    }
}
