// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.PopupControl;

/// <summary>
/// PopupControl with DynamicPopulate
/// </summary>
/// <TestSuite>
///   <Path>PopupControl\DynamicPopulate.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PopupControlBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.PopupControl.DynamicPopulatePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("PopupControl.DynamicPopulate")]
public class PopupControl_DynamicPopulate : AjaxControlToolkit.Testing.Client.PopupControl.PopupControl_Common
{
    public override IEnumerable<PopupControlScenario> PopupControlScenarios
    {
        get
        {
            DynamicPopulatePage page = new DynamicPopulatePage();
            yield return new PopupControlScenario(page.PopupControl, page.Panel, page.Commit, page.Clear, page.Cancel, page.CommitCancel, page.CancelCommit);
        }
    }

    [WebTestMethod]
    public void DynamicPopulate()
    {
        DynamicPopulatePage page = new DynamicPopulatePage();
        page.PopupControl.Element.Focus();
        page.Label.WaitForInnerText(page.PopupControl.DynamicContextKey.Value, 3);
    }
}
