// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.PagingBulletedList;

/// <summary>
/// Basic PagingBulletedList tests
/// </summary>
/// <TestSuite>
///   <Path>PagingBulletedList\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PagingBulletedListBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.PagingBulletedList.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("PagingBulletedList.Simple")]
public class PagingBulletedList_Simple : PagingBulletedList_Common
{
    [WebTestMethod]
    public void Initialize()
    {
        SimplePage page = new SimplePage();
        Assert.AreEqual(0, page.PagingBulletedList.SelectedIndex.Value);
        page.PagingBulletedList.AssertIndices("Z", "1", "2", "5", "A", "B", "C", "D");
        page.PagingBulletedList.AssertCurrentValues("zzzzzz");
    }

    [WebTestMethod]
    public void ChangeIndex()
    {
        SimplePage page = new SimplePage();
        page.PagingBulletedList.SelectIndex(1);

        page.PagingBulletedList.Invalidate();
        page.PagingBulletedList.SelectedIndex.Require();
        page.PagingBulletedList.Indices.Require();
        page.PagingBulletedList.CurrentValues.Require();

        Assert.AreEqual(1, page.PagingBulletedList.SelectedIndex.Value);
        page.PagingBulletedList.AssertIndices("Z", "1", "2", "5", "A", "B", "C", "D");
        page.PagingBulletedList.AssertCurrentValues("1", "11", "111");
    }

    [WebTestMethod]
    public void Sort()
    {
        SimplePage page = new SimplePage();
        page.PagingBulletedList.SortOnClient.Value = true;

        page.PagingBulletedList.Invalidate();
        page.PagingBulletedList.SelectedIndex.Require();
        page.PagingBulletedList.Indices.Require();
        page.PagingBulletedList.CurrentValues.Require();

        Assert.AreEqual(0, page.PagingBulletedList.SelectedIndex.Value);
        page.PagingBulletedList.AssertIndices("1", "2", "5", "A", "B", "C", "D", "Z");
        page.PagingBulletedList.AssertCurrentValues("1", "11", "111");
    }

    [WebTestMethod]
    public void ChangeIndexSize()
    {
        SimplePage page = new SimplePage();
        page.PagingBulletedList.IndexSize.Value = 2;

        page.PagingBulletedList.Invalidate();
        page.PagingBulletedList.SelectedIndex.Require();
        page.PagingBulletedList.Indices.Require();
        page.PagingBulletedList.CurrentValues.Require();

        Assert.AreEqual(0, page.PagingBulletedList.SelectedIndex.Value);
        page.PagingBulletedList.AssertIndices("ZZ", "1", "11", "2", "5", "A", "B", "C", "D");
        page.PagingBulletedList.AssertCurrentValues("zzzzzz");
    }

    [WebTestMethod]
    public void MaximumItems()
    {
        SimplePage page = new SimplePage();
        page.PagingBulletedList.MaximumItemsPerPage.Value = 3;

        page.PagingBulletedList.Invalidate();
        page.PagingBulletedList.SelectedIndex.Require();
        page.PagingBulletedList.Indices.Require();
        page.PagingBulletedList.CurrentValues.Require();

        Assert.AreEqual(0, page.PagingBulletedList.SelectedIndex.Value);
        page.PagingBulletedList.AssertIndices("zzzzzz", "111", "a", "d");
        page.PagingBulletedList.AssertCurrentValues("zzzzzz", "1", "11");
    }

    [WebTestMethod]
    public void Postback()
    {
        SimplePage page = new SimplePage();
        page.PagingBulletedList.SelectIndex(1);
        
        page.Button.Click(true);

        page.PagingBulletedList.Invalidate();
        page.PagingBulletedList.SelectedIndex.Require();
        page.PagingBulletedList.Indices.Require();
        page.PagingBulletedList.CurrentValues.Require();

        Assert.AreEqual(1, page.PagingBulletedList.SelectedIndex.Value);
        page.PagingBulletedList.AssertIndices("Z", "1", "2", "5", "A", "B", "C", "D");
        page.PagingBulletedList.AssertCurrentValues("1", "11", "111");
    }
}