// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.NoBot Model
    /// </summary>
    /// <TestComponent Name="NoBot">
    ///   <ToolkitType>AjaxControlToolkit.NoBotExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.NoBot.NoBot_Common</CommonTestSuite>
    /// </TestComponent>
    public class NoBotBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// ClientState
        /// </summary>
        public BehaviorProperty<string> ClientState
        {
            get { return _clientState; }
        }
        private BehaviorProperty<string> _clientState;

        /// <summary>
        /// AjaxControlToolkit.NoBot Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public NoBotBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _clientState = BehaviorProperty<string>.CreateProperty(this, "ClientState");
        }
    }
}
