// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ModalPopup;

/// <summary>
/// Ensure that the OnOk and OnCancel scripts get called
/// </summary>
/// <TestSuite>
///   <Path>ModalPopup\OnOkCancelScripts.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ModalPopupBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ModalPopup.OnOkCancelScriptsPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ModalPopup.OnOkCancelScripts")]
public class ModalPopup_OnOkCancelScripts : AjaxControlToolkit.Testing.Client.ModalPopup.ModalPopup_Common
{
    public override IEnumerable<ModalPopupBehavior> ModalPopups
    {
        get 
        {
            yield return new OnOkCancelScriptsPage().ModalPopupExtender1; 
        }
    }

    [WebTestMethod]
    public void OnOkScript()
    {
        OnOkCancelScriptsPage page = new OnOkCancelScriptsPage();
        page.ModalPopupExtender1.ShowPopup();
        page.ModalPopupExtender1.ClickOK();
        Assert.AreEqual(System.Drawing.Color.Green, page.Label1.GetAttributes().Style.BackgroundColor);
    }

    [WebTestMethod]
    public void OnCancelScript()
    {
        OnOkCancelScriptsPage page = new OnOkCancelScriptsPage();
        page.ModalPopupExtender1.ShowPopup();
        page.ModalPopupExtender1.ClickCancel();
        Assert.AreEqual(System.Drawing.Color.Red, page.Label1.GetAttributes().Style.BackgroundColor);
    }
}