// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ListSearch;

/// <summary>
/// Core tests for ListSearch
/// </summary>
/// <TestSuite>
///   <Path>ListSearch\Core.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ListSearchBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ListSearch.CorePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ListSearch.Core")]
public class ListSearch_Core : AjaxControlToolkit.Testing.Client.ListSearch.ListSearch_Common
{
    public override IEnumerable<ListSearchBehavior> ListSearchBehaviors
    {
        get
        {
            CorePage page = new CorePage();
            yield return page.ListSearchListBox;
            yield return page.ListSearchDropDownList;
        }
    }

    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera, "Opera doesn't seem to support document.createEvent(\"KeyboardEvent\")")]
    [WebTestFailureTag(Browsers.Safari, "Safari doesn't seem to support DispatchEvent of a KeyboardEvent")]
    public void OnChangeWhenBlur()
    {
        foreach (ListSearchBehavior listSearchBehavior in ListSearchBehaviors)
        {
            HtmlSelectElement listElement = listSearchBehavior.Element;

            HtmlElement output = listSearchBehavior.Page.Elements.Find(listElement.Id + "Output");
            Assert.AreEqual("", output.GetAttributes().InnerText);
            Common.TypeText(listElement, "C", true, false);
            Assert.AreEqual("", output.GetAttributes().InnerText);
            listElement.Blur();
            Assert.AreEqual("Charlie", output.GetAttributes().InnerText);
        }
    }

    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera, "Opera doesn't seem to support document.createEvent(\"KeyboardEvent\")")]
    [WebTestFailureTag(Browsers.Safari, "Safari doesn't seem to support DispatchEvent of a KeyboardEvent")]
    public void OnChangeWhenEnter()
    {
        foreach (ListSearchBehavior listSearchBehavior in ListSearchBehaviors)
        {
            HtmlSelectElement listElement = listSearchBehavior.Element;

            HtmlElement output = listSearchBehavior.Page.Elements.Find(listElement.Id + "Output");
            Assert.AreEqual("", output.GetAttributes().InnerText);
            Common.TypeText(listElement, "del", true, false);
            Assert.AreEqual("", output.GetAttributes().InnerText);
            Common.TypeText(listElement, "\r", false, false);
            Assert.AreEqual("Delta", output.GetAttributes().InnerText);
            listElement.Blur();
        }
    }
}
