// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.HoverExtender Model
    /// </summary>
    /// <TestComponent Name="Hover">
    ///   <ToolkitType>AjaxControlToolkit.HoverExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.Hover.Hover_Common</CommonTestSuite>
    /// </TestComponent>
    public class HoverBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// HoverDelay
        /// </summary>
        public BehaviorProperty<int> HoverDelay
        {
            get { return _hoverDelay; }
        }
        private BehaviorProperty<int> _hoverDelay;

        /// <summary>
        /// HoverScript
        /// </summary>
        public BehaviorProperty<string> HoverScript
        {
            get { return _hoverScript; }
        }
        private BehaviorProperty<string> _hoverScript;

        /// <summary>
        /// UnhoverDelay
        /// </summary>
        public BehaviorProperty<int> UnhoverDelay
        {
            get { return _unhoverDelay; }
        }
        private BehaviorProperty<int> _unhoverDelay;

        /// <summary>
        /// UnhoverScript
        /// </summary>
        public BehaviorProperty<string> UnhoverScript
        {
            get { return _unhoverScript; }
        }
        private BehaviorProperty<string> _unhoverScript;

        /// <summary>
        /// Hover event
        /// </summary>
        public BehaviorEvent Hover
        {
            get { return _hover; }
        }
        private BehaviorEvent _hover;

        /// <summary>
        /// UnHover event
        /// </summary>
        public BehaviorEvent UnHover
        {
            get { return _unHover; }
        }
        private BehaviorEvent _unHover;


        /// <summary>
        /// AjaxControlToolkit.HoverExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public HoverBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : this (element, behaviorID, null, page)
        { }

        /// <summary>
        /// AjaxControlToolkit.HoverExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="behaviorReferenceExpression">JavaScript expression used to reference the behavior</param>
        /// <param name="page">Page Model</param>
        public HoverBehavior(HtmlElement element, string behaviorID, string behaviorReferenceExpression, ToolkitTestPage page)
            : base (element, behaviorID, behaviorReferenceExpression, page)
        {
            _hoverDelay = BehaviorProperty<int>.CreateProperty(this, "hoverDelay");
            _hoverScript = BehaviorProperty<string>.CreateProperty(this, "hoverScript");
            _unhoverDelay = BehaviorProperty<int>.CreateProperty(this, "unhoverDelay");
            _unhoverScript = BehaviorProperty<string>.CreateProperty(this, "unhoverScript");
            _hover = BehaviorEvent<object>.CreateEvent(this, "hover");
            _unHover = BehaviorEvent<object>.CreateEvent(this, "unhover");
        }
        /// <summary>
        /// hover
        /// </summary>
        public void HoverOver()
        {
            _hover.Register();
            this.Element.DispatchEvent(new HtmlMouseEvent("mouseover"));
            _hover.Wait(5);
        }

        /// <summary>
        /// unhover
        /// </summary>
        public void HoverOut()
        {
            _unHover.Register();
            this.Element.DispatchEvent(new HtmlMouseEvent("mouseout"));
            _unHover.Wait(5);
        }

    }
}