// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.FilteredTextBox
{
    /// <summary>
    /// Common FilteredTextBox tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.FilteredTextBoxBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("FilteredTextBox")]
    public abstract class FilteredTextBox_Common
    {
        public abstract IEnumerable<FilteredTextBoxBehavior> FilteredTextBoxes
        {
            get;
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_SetRandomTextAndValidateFilter()
        {
            foreach (FilteredTextBoxBehavior filteredTextBox in FilteredTextBoxes)
            {
                filteredTextBox.SetTextAndAssertValid("123abcd@$#()$*()$*$)($*)(*$#()#*$)*#)@KHWHEWEIUWHEB_+_+_=/.;<>");
                filteredTextBox.SetTextAndAssertValid("2423404kjszhf `h__@!)+4535_!+! JOWIJ wirjwqe");
                filteredTextBox.AppendTextAndAssertValid("23KLJHu92084qao[q=-w2_+=-2-3sSADE;';.,,l[]wpewq` eqwe");
            }
        }
    }
}