// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.FilteredTextBox;

/// <summary>
/// Make sure that when filtermode is set to valid chars the text is filtered
/// correctly to include only those
/// </summary>
/// <TestSuite>
///   <Path>FilteredTextBox\FilterModeValidChars.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.FilteredTextBoxBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.FilteredTextBox.FilterModeValidCharsPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("FilteredTextBox.FilterModeValidChars")]
public class FilteredTextBox_FilterModeValidChars : AjaxControlToolkit.Testing.Client.FilteredTextBox.FilteredTextBox_Common
{
    public override IEnumerable<FilteredTextBoxBehavior> FilteredTextBoxes
    {
        get 
        {
            FilterModeValidCharsPage page = new FilterModeValidCharsPage();
            yield return page.FilteredTextBoxExtender1;
            yield return page.FilteredTextBoxExtender2;
            yield return page.FilteredTextBoxExtender3;
            yield return page.FilteredTextBoxExtender4;
            yield return page.FilteredTextBoxExtender5; 
        }
    }
}