// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.DynamicPopulate
{
    /// <summary>
    /// Common DynamicPopulate tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.DynamicPopulateBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("DynamicPopulate")]
    public abstract class DynamicPopulate_Common
    {
        public const string DynamicContent = "Dynamic Content . . .";

        public abstract IEnumerable<Tuple<DynamicPopulateBehavior, string>> DynamicPopulation
        {
            get;
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_Populate()
        {
            foreach (Tuple<DynamicPopulateBehavior, string> tuple in DynamicPopulation)
            {
                tuple.First.AssertPopulated(tuple.Second);
            }
        }
    }
}