// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.CollapsiblePanel;

/// <summary>
/// Work Item 6986 - CollapsiblePanel removes initial focus.
/// </summary>
/// <TestSuite>
///   <Path>CollapsiblePanel\WorkItem6986.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CollapsiblePanelBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.CollapsiblePanel.WorkItem6986Page</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("CollapsiblePanel.WorkItem6986")]
public class CollapsiblePanel_WorkItem6986 : CollapsiblePanel_Common
{
    /// <summary>
    /// All collapsible panels on the page
    /// </summary>
    public override IEnumerable<CollapsiblePanelBehavior> CollapsiblePanels
    {
        get { yield return new WorkItem6986Page().CollapsiblePanel; }
    }

    /// <summary>
    /// Whether or not the page can post back
    /// </summary>
    public override bool SupportsPostback
    {
        get { return false; }
    }

    /// <summary>
    /// Perform a postback
    /// </summary>
    /// <param name="collapsiblePanel">Behavior responsible for triggering the postback</param>
    public override void DoPostback(CollapsiblePanelBehavior collapsiblePanel)
    {
    }

    /// <summary>
    /// Ensure the CollapsiblePanel doesn't steal focus from the textbox
    /// </summary>
    [WebTestMethod]
    [WebTestTag("6986")]
    public void FocusPreserved()
    {
        WorkItem6986Page page = new WorkItem6986Page();

        page.TextBox.Focus();
        Assert.AreEqual(Color.Red, page.TextBox.GetAttributes().Style.BackgroundColor);
    }
}