// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.CascadingDropDown;

/// <summary>
/// SelectedIndexChanged inside a template
/// </summary>
/// <TestSuite>
///   <Path>CascadingDropDown\SelectedIndexChanged.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CascadingDropDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.CascadingDropDown.SelectedIndexChangedPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("CascadingDropDown.SelectedIndexChanged")]
public class CascadingDropDown_SelectedIndexChanged : AjaxControlToolkit.Testing.Client.CascadingDropDown.CascadingDropDown_Common
{
    [WebTestMethod]
    public void SelectedIndexChangeFired()
    {
        SelectedIndexChangedPage page = new SelectedIndexChangedPage();

        page.DropDownList.SetSelectedIndex(2);
        page.Button.Click(true);
        Assert.AreEqual("Audi (value)", page.Label.GetAttributes().InnerText);

        page.DropDownList.SetSelectedIndex(3);
        page.Button.Click(true);
        Assert.AreEqual("BMW (value)", page.Label.GetAttributes().InnerText);
    }
}
