// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client.CascadingDropDown;

namespace AjaxControlToolkit.Testing.Client.CascadingDropDown
{
    /// <summary>
    /// Common CascadingDropDown tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.CascadingDropDownBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("CascadingDropDown")]
    public abstract class CascadingDropDown_Common
    {
        protected OptionInformation[] _optionInformationsMake = new OptionInformation[] { new OptionInformation("Acura", "Acura"), new OptionInformation("Audi", "Audi (value)"), new OptionInformation("BMW", "BMW (value)") };
        protected OptionInformation[] _optionInformationsMakeBmwModel = new OptionInformation[] { new OptionInformation("3 series", "3 series (value)"), new OptionInformation("5 series", "5 series (value)"), new OptionInformation("7 series", "7 series (value)") };
        protected OptionInformation[] _optionInformationsMakeBmwModel3series = new OptionInformation[] { new OptionInformation("Blue", "Blue (value)"), new OptionInformation("Sky Blue", "Sky Blue (value)"), new OptionInformation("Racing Blue", "Racing Blue (value)") };
        protected OptionInformation[] _optionInformationsMakeBmwModel5series = new OptionInformation[] { new OptionInformation("Yellow", "Yellow (value)"), new OptionInformation("Banana", "Banana (value)") };
        protected OptionInformation[] _optionInformationsMakeAudiModel = new OptionInformation[] { new OptionInformation("A4", "A4 (value)"), new OptionInformation("S4", "S4 (value)"), new OptionInformation("A6", "A6 (value)") };
        protected OptionInformation[] _optionInformationsMakeAudiModelA4 = new OptionInformation[] { new OptionInformation("Azure", "Azure (value)"), new OptionInformation("Light Azure", "Light Azure (value)"), new OptionInformation("Dark Azure", "Dark Azure (value)") };

        protected void AssertDropDownsDisabled(params CascadingDropDownBehavior[] cascadingDropDownBehaviors)
        {
            foreach (CascadingDropDownBehavior cascadingDropDownBehavior in cascadingDropDownBehaviors)
            {
                cascadingDropDownBehavior.Require(cascadingDropDownBehavior.Disabled);
            }
            foreach (CascadingDropDownBehavior cascadingDropDownBehavior in cascadingDropDownBehaviors)
            {
                cascadingDropDownBehavior.AssertDisabled();
            }
        }

        public static void RegisterForSelectionChanged(params CascadingDropDownBehavior[] cascadingDropDownBehaviors)
        {
            foreach (CascadingDropDownBehavior cascadingDropDownBehavior in cascadingDropDownBehaviors)
            {
                cascadingDropDownBehavior.SelectionChanged.Register();
            }
        }

        public static void WaitForPopulation(params CascadingDropDownBehavior[] cascadingDropDownBehaviors)
        {
            foreach (CascadingDropDownBehavior cascadingDropDownBehavior in cascadingDropDownBehaviors)
            {
                cascadingDropDownBehavior.Invalidate(cascadingDropDownBehavior.Disabled);
                if (cascadingDropDownBehavior.Disabled.Value)
                {
                    cascadingDropDownBehavior.SelectionChanged.Wait(3);
                    cascadingDropDownBehavior.Invalidate(cascadingDropDownBehavior.Disabled);
                }
                Assert.IsFalse(cascadingDropDownBehavior.Disabled.Value);
            }
        }
    }
}
