// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Accordion;

/// <summary>
/// Verify early creation of static child controls in an Accordion
/// </summary>
/// <TestSuite>
///   <Path>Accordion\WorkItem10524.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AccordionBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Accordion.WorkItem10524Page</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Accordion.WorkItem10524")]
public class Accordion_WorkItem10524 : Accordion_Common
{
    /// <summary>
    /// Accordion scenarios for common tests
    /// </summary>
    public override IEnumerable<AccordionScenario> AccordionScenarios
    {
        get { yield return new AccordionScenario(new WorkItem10524Page().Accordion, 4, null); }
    }

    /// <summary>
    /// Verify the controls were created early enough in the page life cycle
    /// </summary>
    [WebTestMethod]
    [WebTestTag("10524")]
    public void ControlsCreatedEarly()
    {
        WorkItem10524Page page = new WorkItem10524Page();
        Assert.AreEqual("Updated", page.Textbox.GetAttributes().Value);
    }
}