// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Accordion;

/// <summary>
/// Test an Accordion with no panes
/// </summary>
/// <TestSuite>
///   <Path>Accordion\NoPanes.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AccordionBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Accordion.NoPanesPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Accordion.NoPanes")]
public class Accordion_NoPanes : AjaxControlToolkit.Testing.Client.Accordion.Accordion_Common
{
    /// <summary>
    /// Accordion behaviors on the page along with the number of panes in
    /// each Accordion and a button used to cause a postback or partial
    /// postback
    /// </summary>
    public override IEnumerable<AccordionScenario> AccordionScenarios
    {
        get
        {
            NoPanesPage page = new NoPanesPage();
            yield return new AccordionScenario(page.Accordion, 0, page.Postback);
        }
    }
}