<%@ Page
    Language="C#"
    CodeFile="TestDriver.aspx.cs"
    Inherits="AjaxControlToolkit.Testing.Client.TestDriver" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>AJAX Control Toolkit Automated Client-Side Testing</title>
    <link rel="stylesheet" type="text/css" href="<%= Page.ClientScript.GetWebResourceUrl(typeof(Microsoft.Web.Testing.Engine.TestDriverPage), "Microsoft.Web.Testing.Engine.Resources.driver.css") %>" />
    <style type="text/css">
        body
        {
            font-size: 10pt;
            font-family: Verdana;
        }
    
        .testCaseList
        {
            width: 200px;
            padding: 5px;
            border: solid 1px #666666;
            margin-right: 10px;
            text-align: center;
        }

        .testCaseListNode
        {
            font-size: 10px;
            padding-bottom: 0px;
        }

        .testCaseListLeaf
        {
            font-size: 9.5px;
            padding: 0px;
        }

        a
        {
            color: Blue;
            text-decoration: none;
        }

        a:hover
        {
            color: Blue;
            text-decoration: underline;
        }
    </style>
</head>
<body><form runat="server"><div>
    <asp:ScriptManager runat="server" ID="ScriptManager" EnablePageMethods="true" EnablePartialRendering="true">
        <Scripts>
            <asp:ScriptReference Name="Microsoft.Web.Testing.Engine.Resources.TestcaseExecutor.js" Assembly="Microsoft.Web.Testing" />
            <%-- TestDriver.js must be declared after the Microsoft.Web.Testing scripts because they redefine important functions --%>
            <asp:ScriptReference Path="TestDriver.js" />
            
            <%-- Animation scripts --%>
            <asp:ScriptReference Name="AjaxControlToolkit.Common.Common.js" Assembly="AjaxControlToolkit" />
            <asp:ScriptReference Name="AjaxControlToolkit.Compat.Timer.Timer.js" Assembly="AjaxControlToolkit" />
            <asp:ScriptReference Name="AjaxControlToolkit.Animation.Animations.js" Assembly="AjaxControlToolkit" />
        </Scripts>
    </asp:ScriptManager>
    
    <asp:UpdatePanel runat="server" ID="DriverPageUpdatePanel">
        <ContentTemplate>
            <%-- Controls that exist in another frame whose actions are routed here --%>
            <asp:Button ID="btnRun" runat="server" Text="Run Tests" OnClick="btnRun_Click" Style="display: none;"/>
            <asp:Label ID="lblThread" runat="server" Style="display: none;" />
            <asp:DropDownList ID="cmbVerbosity" runat="server" Style="display: none;">
                    <asp:ListItem Text="Concise" />
                    <asp:ListItem Text="Standard" Selected="true" />
                    <asp:ListItem Text="Verbose" />
                </asp:DropDownList>
            <asp:CheckBox ID="chkSkipFail" runat="server" Style="display: none;" />
            <asp:CheckBox ID="chkFilter" runat="server" Style="display: none;" />
            
            <%-- Test cases --%>
            <asp:TreeView ID="treeTestCases" runat="server" ShowCheckBoxes="Leaf" NodeIndent="3"
                NodeStyle-CssClass="testCaseListNode" LeafNodeStyle-CssClass="testCaseListNode">
                <Nodes>
                    <asp:TreeNode Text="All Test Cases" />
                </Nodes>
            </asp:TreeView>
            
        </ContentTemplate>
    </asp:UpdatePanel>
</div></form></body>
</html>