// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.UpdatePanelAnimationExtender Model
    /// </summary>
    /// <TestComponent Name="UpdatePanelAnimation">
    ///   <ToolkitType>AjaxControlToolkit.UpdatePanelAnimationExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.UpdatePanelAnimation.UpdatePanelAnimation_Common</CommonTestSuite>
    /// </TestComponent>
    public class UpdatePanelAnimationBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// OnUpdating
        /// </summary>
        public GenericAnimationBehavior OnUpdating
        {
            get { return _onUpdating; }
        }
        private GenericAnimationBehavior _onUpdating;

        /// <summary>
        /// OnUpdated
        /// </summary>
        public GenericAnimationBehavior OnUpdated
        {
            get { return _onUpdated; }
        }
        private GenericAnimationBehavior _onUpdated;

        /// <summary>
        /// AjaxControlToolkit.UpdatePanelAnimationExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public UpdatePanelAnimationBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _onUpdating = new GenericAnimationBehavior(element, behaviorID + "_OnUpdating",
                string.Format("{0}._onUpdating", base.BehaviorReferenceExpression), page);
            _onUpdated = new GenericAnimationBehavior(element, behaviorID + "_OnUpdated",
                string.Format("{0}._onUpdated", base.BehaviorReferenceExpression), page);
        }
    }
}