// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ToggleButton;

/// <summary>
/// Validate that ToggleButton operates properly when there are postbacks from a page 
/// and if autopostback is set of the button
/// </summary>
/// <TestSuite>
///   <Path>ToggleButton\PostBacks.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ToggleButtonBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ToggleButton.PostBacksPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ToggleButton.PostBacks")]
public class ToggleButton_PostBacks : AjaxControlToolkit.Testing.Client.ToggleButton.ToggleButton_Common
{

    public override IEnumerable<ToggleButtonBehavior> ToggleButtons
    {
        get 
        {
            PostBacksPage page = new PostBacksPage();
            yield return page.ToggleButtonExtender1;
            yield return page.ToggleButtonExtender2; 
        }
    }
    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera | Browsers.Safari, "TODO: ???")]
    public void PostbackAndValidateValue()
    {
        PostBacksPage page = new PostBacksPage();
        ToggleButtonBehavior toggleButton = page.ToggleButtonExtender2;
        Assert.IsFalse(toggleButton.IsChecked());
        toggleButton.Element.Click(true);
        Assert.IsTrue(toggleButton.IsChecked());
        string label1Postback = page.Label1.GetAttributes().InnerText;
        Assert.AreEqual(label1Postback, "postback");
        page.Button1.Click();
        Assert.IsTrue(toggleButton.IsChecked());
    }
}