// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Slider;

/// <summary>
/// Test to ensure that a slider that does not have a bound 
/// textbox works fine. This is a basic slider scenario.
/// </summary>
/// <TestSuite>
///   <Path>Slider\SliderWithNoBoundTextBox.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.SliderBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Slider.SliderWithNoBoundTextBoxPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Slider.SliderWithNoBoundTextBox")]
public class Slider_SliderWithNoBoundTextBox : AjaxControlToolkit.Testing.Client.Slider.Slider_Common
{
    public override IEnumerable<SliderBehavior> Sliders
    {
        get 
        {
            yield return new SliderWithNoBoundTextBoxPage().sliderExtender;
        }
    }
}