// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.SlideShow;

/// <summary>
/// SlideShow test for links to missing pictures or bad links 
/// </summary>
/// <TestSuite>
///   <Path>SlideShow\SlidesNavigation.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.SlideShowBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.SlideShow.SlidesNavigationPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("SlideShow.SlidesNavigation")]
public class SlideShow_SlidesNavigation : AjaxControlToolkit.Testing.Client.SlideShow.SlideShow_Common
{

    [WebTestMethod]
    [WebTestTag("Smoke")]
    public void TestMultipleSlidesNavigation()
    {
        SlidesNavigationPage page = new SlidesNavigationPage();
        SlideShowBehavior slideShow = page.slideshowextend1;
        this.ValidateSlide1(page);
        slideShow.ClickNext();
        this.ValidateSlide2(page);
        slideShow.ClickNext();
        this.ValidateSlide3(page);
        slideShow.ClickPrevious();
        this.ValidateSlide2(page);
    }

    [WebTestMethod]
    public void ClickingPreviousOnFirstSlide()
    {
        SlidesNavigationPage page = new SlidesNavigationPage();
        SlideShowBehavior slideShow = page.slideshowextend1;
        this.ValidateSlide1(page);
        // clicking previous should still cause no change and the slide show should be at the first slide
        slideShow.ClickPrevious();
        this.ValidateSlide1(page);
    }

    [WebTestMethod]
    public void ClickingNextOnLastSlide()
    {
        SlidesNavigationPage page = new SlidesNavigationPage();
        SlideShowBehavior slideShow = page.slideshowextend1;
        slideShow.ClickNext();
        slideShow.ClickNext();
        slideShow.ClickNext();
        this.ValidateSlide4(page);
        slideShow.ClickNext(); // clicking next should be a noop since the next button is disabled
        // still stay at the same slide
        this.ValidateSlide4(page);
    }

    [WebTestMethod]
    [WebTestFailureTag(Browsers.Safari, "TODO: Investigate.")]
    public void PlayMode()
    {
        SlidesNavigationPage page = new SlidesNavigationPage();
        SlideShowBehavior slideShow = page.slideshowextend1;
        slideShow.SlideChanged.Register();
        this.ValidateSlide1(page);
        slideShow.ClickPlay();
        slideShow.SlideChanged.Wait(slideShow.PlayInterval.Value + 1);
        this.ValidateSlide2(page);
        slideShow.SlideChanged.Wait(slideShow.PlayInterval.Value + 1);
        this.ValidateSlide3(page);
        slideShow.SlideChanged.Wait(slideShow.PlayInterval.Value + 1);
        this.ValidateSlide4(page);
        // make sure play stops at the last slide because Loop is set to false
        System.Threading.Thread.Sleep(slideShow.PlayInterval.Value * 2);
        this.ValidateSlide4(page);
    }

    private void ValidateSlide1(SlidesNavigationPage page)
    {
        page.slideshowextend1.AssertSlide("Blue_hills.jpg", "Blue Hills", "Go Blue");
    }
    private void ValidateSlide2(SlidesNavigationPage page)
    {
        page.slideshowextend1.AssertSlide("Winter.jpg", "Winter", "Wintery...");
    }
    private void ValidateSlide3(SlidesNavigationPage page)
    {
        page.slideshowextend1.AssertSlide("Water_lilies.jpg", "Water lillies", "Lillies in the water");
    }
    private void ValidateSlide4(SlidesNavigationPage page)
    {
        page.slideshowextend1.AssertSlide("VerticalPicture.jpg", "Sedona", "Portrait style picture");
    }

}