// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.RoundedCorners;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>RoundedCorners\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.RoundedCornersBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.RoundedCorners.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("RoundedCorners.Sample")]
[WebTestTag("SampleWebSite")]
public class RoundedCorners_Sample : RoundedCorners_Common
{
    public override IEnumerable<RoundedCornersBehavior> RoundedCornersBehaviors
    {
        get
        {
            SamplePage page = new SamplePage();
            yield return page.RoundedCornersExtender1;
        }

        // TODO: More focused testing of SampleWebSite content
    }
}
