// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.PasswordStrength;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>PasswordStrength\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PasswordStrengthBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.PasswordStrength.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("PasswordStrength.Sample")]
[WebTestTag("SampleWebSite")]
public class PasswordStrength_Sample : AjaxControlToolkit.Testing.Client.PasswordStrength.PasswordStrength_Common
{
    public override IEnumerable<PasswordStrengthBehavior> PasswordStrengths
    {
        get
        {
            SamplePage page = new SamplePage();
            yield return page.PasswordStrength1;
            yield return page.PasswordStrength2;
            yield return page.PasswordStrength3;
        }
    }
}