// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.NoBot;

/// <summary>
/// NoBot tests using OnGenerateChallengeAndResponse
/// </summary>
/// <TestSuite>
///   <Path>NoBot\CustomChallenge.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.NoBotBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.NoBot.CustomChallengePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("NoBot.CustomChallenge")]
public class NoBot_CustomChallenge : NoBot_Common
{
    public override IEnumerable<Tuple<NoBotBehavior, HtmlElement, HtmlElement, HtmlInputElement, HtmlInputElement>> NoBotPages
    {
        get
        {
            CustomChallengePage page = new CustomChallengePage();
            yield return new Tuple<NoBotBehavior, HtmlElement, HtmlElement, HtmlInputElement, HtmlInputElement>(page.NoBot, page.LabelValid, page.LabelState, page.Postback, page.EmptyCache);
        }
    }
}
