// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.NoBot;

/// <summary>
/// Core tests for NoBot
/// </summary>
/// <TestSuite>
///   <Path>NoBot\Core.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.NoBotBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.NoBot.CorePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("NoBot.Core")]
public class NoBot_Core : NoBot_Common
{
    public override IEnumerable<Tuple<NoBotBehavior, HtmlElement, HtmlElement, HtmlInputElement, HtmlInputElement>> NoBotPages
    {
        get
        {
            CorePage page = new CorePage();
            yield return new Tuple<NoBotBehavior, HtmlElement, HtmlElement, HtmlInputElement, HtmlInputElement>(page.NoBot, page.LabelValid, page.LabelState, page.Postback, page.EmptyCache);
        }
    }
}
