// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBox;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>MutuallyExclusiveCheckBox\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBoxBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBox.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("MutuallyExclusiveCheckBox.Sample")]
[WebTestTag("SampleWebSite")]
public class MutuallyExclusiveCheckBox_Sample : AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBox.MutuallyExclusiveCheckBox_Common
{
    public override IEnumerable<MutuallyExclusiveCheckBoxBehavior> MutuallyExclusiveCheckBoxes
    {
        get
        {
            SamplePage page = new SamplePage();
            yield return page.MutuallyExclusiveCheckboxExtender1;
            yield return page.MutuallyExclusiveCheckboxExtender2;
            yield return page.MutuallyExclusiveCheckboxExtender3;
            yield return page.MutuallyExclusiveCheckboxExtender4;
            yield return page.MutuallyExclusiveCheckboxExtender5;
            yield return page.MutuallyExclusiveCheckboxExtender6;
            yield return page.MutuallyExclusiveCheckboxExtender7;
        }
    }


}