// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.DynamicPopulateExtender Model
    /// </summary>
    /// <TestComponent Name="DynamicPopulate">
    ///   <ToolkitType>AjaxControlToolkit.DynamicPopulateExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.DynamicPopulate.DynamicPopulate_Common</CommonTestSuite>
    /// </TestComponent>
    public class DynamicPopulateBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// ClearContentsDuringUpdate
        /// </summary>
        public BehaviorProperty<bool> ClearContentsDuringUpdate
        {
            get { return _clearContentsDuringUpdate; }
        }
        private BehaviorProperty<bool> _clearContentsDuringUpdate;

        /// <summary>
        /// ContextKey
        /// </summary>
        public BehaviorProperty<string> ContextKey
        {
            get { return _contextKey; }
        }
        private BehaviorProperty<string> _contextKey;

        /// <summary>
        /// PopulateTrigger
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> PopulateTrigger
        {
            get { return _populateTrigger; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _populateTrigger;

        /// <summary>
        /// ServiceMethod
        /// </summary>
        public BehaviorProperty<string> ServiceMethod
        {
            get { return _serviceMethod; }
        }
        private BehaviorProperty<string> _serviceMethod;

        /// <summary>
        /// ServicePath
        /// </summary>
        public BehaviorProperty<string> ServicePath
        {
            get { return _servicePath; }
        }
        private BehaviorProperty<string> _servicePath;

        /// <summary>
        /// UpdatingCssClass
        /// </summary>
        public BehaviorProperty<string> UpdatingCssClass
        {
            get { return _updatingCssClass; }
        }
        private BehaviorProperty<string> _updatingCssClass;

        /// <summary>
        /// CustomScript
        /// </summary>
        public BehaviorProperty<string> CustomScript
        {
            get { return _customScript; }
        }
        private BehaviorProperty<string> _customScript;

        /// <summary>
        /// CacheDynamicResults
        /// </summary>
        public BehaviorProperty<bool> CacheDynamicResults
        {
            get { return _cacheDynamicResults; }
        }
        private BehaviorProperty<bool> _cacheDynamicResults;

        /// <summary>
        /// Populated
        /// </summary>
        public BehaviorProperty<bool> IsPopulated
        {
            get { return _isPopulated; }
        }
        private BehaviorProperty<bool> _isPopulated;

        /// <summary>
        /// CallID
        /// </summary>
        public BehaviorProperty<int> CallID
        {
            get { return _callID; }
        }
        private BehaviorProperty<int> _callID;

        /// <summary>
        /// CurrentCallID
        /// </summary>
        public BehaviorProperty<int> CurrentCallID
        {
            get { return _currentCallID; }
        }
        private BehaviorProperty<int> _currentCallID;

        /// <summary>
        /// ElementCssClass
        /// </summary>
        public BehaviorProperty<string> ElementCssClass
        {
            get { return _elementCssClass; }
        }
        private BehaviorProperty<string> _elementCssClass;

        /// <summary>
        /// OldCssClass
        /// </summary>
        public BehaviorProperty<string> OldCssClass
        {
            get { return _oldCssClass; }
        }
        private BehaviorProperty<string> _oldCssClass;

        /// <summary>
        /// Dynamically generated content stored in the element's InnerHTML
        /// </summary>
        public BehaviorProperty<string> DynamicContent
        {
            get { return _dynamicContent; }
        }
        private BehaviorProperty<string> _dynamicContent;

        /// <summary>
        /// Populated event
        /// </summary>
        public BehaviorEvent Populated
        {
            get { return _populated; }
        }
        private BehaviorEvent _populated;

        /// <summary>
        /// AjaxControlToolkit.DynamicPopulateExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public DynamicPopulateBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _clearContentsDuringUpdate = BehaviorProperty<bool>.CreateProperty(this, "ClearContentsDuringUpdate");
            _contextKey = BehaviorProperty<string>.CreateProperty(this, "ContextKey");
            _populateTrigger = ReferenceBehaviorProperty<HtmlElement>.CreateProperty(this, "PopulateTriggerID");
            _serviceMethod = BehaviorProperty<string>.CreateProperty(this, "ServiceMethod");
            _servicePath = BehaviorProperty<string>.CreateProperty(this, "ServicePath");
            _updatingCssClass = BehaviorProperty<string>.CreateProperty(this, "UpdatingCssClass");
            _customScript = BehaviorProperty<string>.CreateProperty(this, "CustomScript");
            _cacheDynamicResults = BehaviorProperty<bool>.CreateProperty(this, "cacheDynamicResults");
            _isPopulated = BehaviorProperty<bool>.CreateField(this, "_populated");
            _callID = BehaviorProperty<int>.CreateField(this, "_callID", ReadStrategy.Demand, WriteStrategy.Immediate);
            _currentCallID = BehaviorProperty<int>.CreateField(this, "_currentCallID", ReadStrategy.Demand, WriteStrategy.Immediate);
            _elementCssClass = BehaviorProperty<string>.CreateField(this, "className", "{0}._element");
            _oldCssClass = BehaviorProperty<string>.CreateField(this, "_oldCss", ReadStrategy.Demand, WriteStrategy.Immediate);
            _dynamicContent = BehaviorProperty<string>.CreateField(this, "innerHTML", ReadStrategy.Demand, WriteStrategy.Immediate, "{0}._element");
            _populated = BehaviorEvent<object>.CreateEvent(this, "populated");
        }

        /// <summary>
        /// Ensure the control was populated
        /// </summary>
        /// <param name="content">Expected content</param>
        public void AssertPopulated(string content)
        {
            _populated.Register();
            _populateTrigger.Reference.Click();
            _dynamicContent.Invalidate();
            _populated.Wait(3);
            Assert.AreEqual(content, _dynamicContent.Value);
        }
    }
}