// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.DragPanel;

/// <summary>
/// Basic DragPanel tests
/// </summary>
/// <TestSuite>
///   <Path>DragPanel\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DragPanelBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.DragPanel.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("DragPanel.Simple")]
public class DragPanel_Simple : DragPanel_Common
{
    public override IEnumerable<DragPanelScenario> DragPanelScenarios
    {
        get { yield return new DragPanelScenario(new SimplePage().DragPanel, new Point(0, 0)); }
    }
}
