// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.ResizableControl
{
    /// <summary>
    /// Typical ResizableControl scenarios
    /// </summary>
    public partial class Typical : Page
    {
        protected void Button_Click(object sender, EventArgs e)
        {
            Size s = ResizableControlExtender.Size;
            Label.Text = s.Width + "x" + s.Height;
            s.Width += 10;
            s.Height += 15;
            ResizableControlExtender.Size = s;
        }
    }
}
