// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.NumericUpDown
{
    /// <summary>
    /// Validate that using a webservice with NumericUpDown works fine
    /// </summary>
    public partial class WebService : Page
    {
        [System.Web.Services.WebMethod]
        [System.Web.Script.Services.ScriptMethod]
        public static int NextValue(int current, string tag)
        {
            return current + Int32.Parse(tag);
        }

        [System.Web.Services.WebMethod]
        [System.Web.Script.Services.ScriptMethod]
        public static int PrevValue(int current, string tag)
        {
            return current - Int32.Parse(tag);
        }
    }
}