// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.NoBot
{
    /// <summary>
    /// Core tests for NoBot
    /// </summary>
    public partial class Core : Page
    {
        protected override void OnLoad(EventArgs e)
        {
            NoBot.ResponseMinimumDelaySeconds = NoBot_Common.ActualTimeoutSeconds;
            NoBot.CutoffMaximumInstances = NoBot_Common.CutoffMaximumInstances;
            NoBotState noBotState;
            bool isValid = NoBot.IsValid(out noBotState);
            LabelValid.Text = isValid.ToString();
            LabelState.Text = noBotState.ToString();
            StringBuilder sb = new StringBuilder();
            foreach (KeyValuePair<DateTime, string> kvp in AjaxControlToolkit.NoBot.GetCopyOfUserAddressCache())
            {
                sb.AppendFormat("{0}: {1}<br />", kvp.Key.ToString("u"), kvp.Value);
            }
            LabelCache.Text = sb.ToString();
        }

        protected void EmptyCache_Click(object sender, EventArgs e)
        {
            AjaxControlToolkit.NoBot.EmptyUserAddressCache();
        }
    }
}
