// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.CascadingDropDown
{
    /// <summary>
    /// Typical CascadingDropDown scenarios
    /// </summary>
    public partial class Typical : Page
    {
        [System.Web.Services.WebMethod]
        [System.Web.Script.Services.ScriptMethod]
        public static AjaxControlToolkit.CascadingDropDownNameValue[] GetDropDownContents_PageMethod(string knownCategoryValues, string category)
        {
            AjaxControlToolkit.CascadingDropDownNameValue[] values = new CarsService().GetDropDownContents(knownCategoryValues, category);
            if (1 < values.Length)
            {
                values[1].isDefaultValue = true;
            }
            return values;
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Label3.Text = string.Join(":", new string[] { DropDownList3.SelectedValue, DropDownList3.SelectedItem.Value, DropDownList3.SelectedItem.Text });
            Label4.Text = string.Join(":", new string[] { DropDownList4.SelectedValue, DropDownList4.SelectedItem.Value, DropDownList4.SelectedItem.Text });
        }
    }
}
