<%@ Page Language="C#" CodeFile="TextValuePair.aspx.cs" Inherits="AjaxControlToolkit.Testing.Client.AutoComplete.TextValuePair" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>AutoComplete - TextValuePair</title>
    <style type="text/css">
    /*AutoComplete flyout */

.autocomplete_completionListElement 
{  
	visibility : hidden;
	margin : 0px!important;
	background-color : inherit;
	color : windowtext;
	border : buttonshadow;
	border-width : 1px;
	border-style : solid;
	cursor : 'default';
	overflow : auto;
	height : 200px;
    text-align : left; 
    list-style-type : none;
}

/* AutoComplete highlighted item */

.autocomplete_highlightedListItem
{
	background-color: #ffff99;
	color: black;
	padding: 1px;
}

/* AutoComplete item */

.autocomplete_listItem 
{
	background-color : window;
	color : windowtext;
	padding : 1px;
}
    </style>
</head>
<body>
    <form id="form" runat="server">
        <div>

            <script runat="server">
                [System.Web.Services.WebMethod]
                [System.Web.Script.Services.ScriptMethod]
                public static string[] GetCompletionListWithContext(string prefixText, int count, string contextKey)
                {
                    if (contextKey != null)
                        return "this is a total of fifteen words that will be returned when we use context".Split(' ');

                    if (count == 0)
                    {
                        count = 10;
                    }

                    if (prefixText.Equals("xyz"))
                    {
                        return new string[0];
                    }

                    ArrayList items = new ArrayList(count);
                    Random random = new Random();
                    for (int i = 0; i < count; i++)
                    {
                        char c1 = (char)random.Next(65, 90);
                        char c2 = (char)random.Next(97, 122);
                        char c3 = (char)random.Next(97, 122);

                        items.Add(prefixText + c1 + c2 + c3);
                    }

                    return (string[])items.ToArray(typeof(string));
                }

                [System.Web.Services.WebMethod]
                [System.Web.Script.Services.ScriptMethod]
                public static string[] GetCompletionListWithContextAndValues(string prefixText, int count, string contextKey)
                {
                    System.Collections.Generic.List<string> items = new System.Collections.Generic.List<string>(GetCompletionListWithContext(prefixText, count, contextKey));
                    for (int i = 0; i < items.Count; i++)
                    {
                        items[i] = AjaxControlToolkit.AutoCompleteExtender.CreateAutoCompleteItem(items[i], i.ToString());
                    }
                    return items.ToArray();
                }
            </script>

            <script type="text/javascript">
                function pageLoad() {
                    $find('autoCompleteBehavior3').add_itemSelected(setValue);
                }
                
                function setValue(sender, args) {
                    $get('TextBox3').value = args.get_value();
                }
            </script>

            <b>AutoComplete - TextValuePair</b><br />
            Ensure that if key value pairs are returned by the webservice, AutoComplete deserializes
            it just fine.<br />
            <br />
            <br />
            <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
            <asp:TextBox ID="TextBox3" runat="server"></asp:TextBox>
            <ajaxToolkit:AutoCompleteExtender ID="AutoCompleteExtender3" runat="server" TargetControlID="TextBox3"
                ServiceMethod="GetCompletionListWithContextAndValues" UseContextKey="true" MinimumPrefixLength="2"
                EnableCaching="false" CompletionSetCount="10" CompletionInterval="1000" BehaviorID="autoCompleteBehavior3"
                CompletionListCssClass="autocomplete_completionListElement" CompletionListItemCssClass="autocomplete_listItem"
                CompletionListHighlightedItemCssClass="autocomplete_highlightedListItem" />
        </div>
    </form>
</body>
</html>
