// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.PopupControl;

/// <summary>
/// PopupControl in an UpdatePanel
/// </summary>
/// <TestSuite>
///   <Path>PopupControl\UpdatePanel.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PopupControlBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.PopupControl.UpdatePanelPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("PopupControl.UpdatePanel")]
public class PopupControl_UpdatePanel : AjaxControlToolkit.Testing.Client.PopupControl.PopupControl_Common
{
    public override IEnumerable<PopupControlScenario> PopupControlScenarios
    {
        get
        {
            UpdatePanelPage page = new UpdatePanelPage();
            yield return new PopupControlScenario(page.PopupControl, page.Panel, page.Commit, page.Clear, page.Cancel, page.CommitCancel, page.CancelCommit);
        }
    }
}
