// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBox
{
    /// <summary>
    /// Common MutuallyExclusiveCheckBox tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.MutuallyExclusiveCheckBoxBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("MutuallyExclusiveCheckBox")]
    public abstract class MutuallyExclusiveCheckBox_Common
    {
        public abstract IEnumerable<MutuallyExclusiveCheckBoxBehavior> MutuallyExclusiveCheckBoxes
        {
            get;
        }

        [WebTestMethod]
        public void Common_Selection()
        {
            foreach (MutuallyExclusiveCheckBoxBehavior behavior in MutuallyExclusiveCheckBoxes)
            {
                foreach (MutuallyExclusiveCheckBoxBehavior checkBoxInSet in behavior.MutuallyExclusiveCheckBoxSet)
                {
                    checkBoxInSet.AssertAtMostOneChecked();
                    checkBoxInSet.SelectCheckBox();
                    checkBoxInSet.AssertAtMostOneChecked();
                    checkBoxInSet.SelectCheckBox();
                    checkBoxInSet.AssertNoneChecked();
                }
            }
        }
    }
}