// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.CascadingDropDown;

/// <summary>
/// Specific CascadingDropDown scenarios
/// </summary>
/// <TestSuite>
///   <Path>CascadingDropDown\Specific.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CascadingDropDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.CascadingDropDown.SpecificPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("CascadingDropDown.Specific")]
public class CascadingDropDown_Specific : AjaxControlToolkit.Testing.Client.CascadingDropDown.CascadingDropDown_Common
{
    [WebTestMethod]
    public void UntouchedSubmitWithDefaultValue()
    {
        SpecificPage page = new SpecificPage();
        RegisterForSelectionChanged(page.CascadingDropDown);
        WaitForPopulation(page.CascadingDropDown);

        page.CascadingDropDown.AssertPopulationCorrect(1, _optionInformationsMake);
        Assert.AreEqual("::", page.Label.GetAttributes().InnerText);

        page.Button.Click(true);
        Assert.AreEqual("Audi (value):Audi (value):Audi", page.Label.GetAttributes().InnerText);

        page.Button.Click(true);
        Assert.AreEqual("Audi (value):Audi (value):Audi", page.Label.GetAttributes().InnerText);
    }

    [WebTestMethod]
    public void UntouchedSubmitWithSelectedValue()
    {
        SpecificPage page = new SpecificPage();
        RegisterForSelectionChanged(page.CascadingDropDownSelectedValue);
        WaitForPopulation(page.CascadingDropDownSelectedValue);

        page.Button.Click(true);
        Assert.AreEqual("BMW (value):BMW (value):BMW", page.LabelSelectedValue.GetAttributes().InnerText);
    }

    [WebTestMethod]
    public void HiddenSelect()
    {
        SpecificPage page = new SpecificPage();
        RegisterForSelectionChanged(page.CascadingDropDownHiddenSelectedValue);
        WaitForPopulation(page.CascadingDropDownHiddenSelectedValue);

        page.CascadingDropDownHiddenSelectedValue.AssertPopulationCorrect(2, _optionInformationsMake);
    }

    [WebTestMethod]
    public void ContextKey()
    {
        SpecificPage page = new SpecificPage();
        RegisterForSelectionChanged(page.CascadingDropDownContextKey);
        WaitForPopulation(page.CascadingDropDownContextKey);

        page.CascadingDropDownContextKey.AssertPopulationCorrect(0, new OptionInformation(page.CascadingDropDownContextKey.ContextKey.Value + "-Name", page.CascadingDropDownContextKey.ContextKey.Value + "-Value"));
    }

    [WebTestMethod]
    public void LoadingTextWithoutPromptText()
    {
        SpecificPage page = new SpecificPage();
        RegisterForSelectionChanged(page.CascadingDropDownLoadingTextPromptText);
        WaitForPopulation(page.CascadingDropDownLoadingTextPromptText);

        page.CascadingDropDownLoadingTextPromptText.AssertPopulationCorrect(1, _optionInformationsMake);

        page.Button.Click(true);
        Assert.AreEqual("Audi (value):Audi (value):Audi", page.LabelLoadingTextPromptText.GetAttributes().InnerText);
    }

    [WebTestMethod]
    public void PromptValue()
    {
        SpecificPage page = new SpecificPage();
        RegisterForSelectionChanged(page.CascadingDropDownPromptValue);
        WaitForPopulation(page.CascadingDropDownPromptValue);

        page.CascadingDropDownPromptValue.AssertPopulationCorrect(0, _optionInformationsMake);
    }

    [WebTestMethod]
    public void XmlDefaultValue()
    {
        SpecificPage page = new SpecificPage();
        RegisterForSelectionChanged(page.CascadingDropDownDefaultValueEmptyTextEmptyValue1, page.CascadingDropDownDefaultValueEmptyTextEmptyValue2);
        WaitForPopulation(page.CascadingDropDownDefaultValueEmptyTextEmptyValue1, page.CascadingDropDownDefaultValueEmptyTextEmptyValue2);

        page.CascadingDropDownDefaultValueEmptyTextEmptyValue1.AssertPopulationCorrect(1, new OptionInformation("Acura", "Acura"), new OptionInformation("*Audi", "Audi (value)"), new OptionInformation("BMW", "BMW (value)"), new OptionInformation("Empty Make", "Empty Make"));
        page.CascadingDropDownDefaultValueEmptyTextEmptyValue2.AssertPopulationCorrect(1, new OptionInformation("A4", "A4 (value)"), new OptionInformation("*S4", "S4 (value)"), new OptionInformation("A6", "A6 (value)"));
    }

    [WebTestMethod]
    public void EmptyTextEmptyValue()
    {
        SpecificPage page = new SpecificPage();
        RegisterForSelectionChanged(page.CascadingDropDownDefaultValueEmptyTextEmptyValue1);
        WaitForPopulation(page.CascadingDropDownDefaultValueEmptyTextEmptyValue1);

        page.CascadingDropDownDefaultValueEmptyTextEmptyValue1.SetSelectedIndex(3, page.CascadingDropDownDefaultValueEmptyTextEmptyValue2);
        page.CascadingDropDownDefaultValueEmptyTextEmptyValue2.SelectionChanged.Wait(3);
        page.CascadingDropDownDefaultValueEmptyTextEmptyValue2.AssertPopulationCorrect(0, new OptionInformation(page.CascadingDropDownDefaultValueEmptyTextEmptyValue2.EmptyText.Value, page.CascadingDropDownDefaultValueEmptyTextEmptyValue2.EmptyValue.Value));
    }
}
