// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Animation;

/// <summary>
/// Verify ResolveControlIDs works for all animations
/// </summary>
/// <TestSuite>
///   <Path>Animation\WorkItem9951.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AnimationBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Animation.WorkItem9951Page</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Animation.WorkItem9951")]
public class Animation_WorkItem9951 : Animation_Common
{
    [WebTestMethod]
    [WebTestTag("9551")]
    public void ResolveControlIDs()
    {
        WorkItem9951Page page = new WorkItem9951Page();

        page.Animation1.OnLoad.Ended.Register();
        page.Animation1.OnLoad.Ended.Wait(1, false);
        Assert.AreEqual(Color.Red, page.OnLoad1.GetAttributes().Style.BackgroundColor);

        page.Animation1.OnClick.Ended.Register();
        page.Target1.Click();
        page.Animation1.OnClick.Ended.Wait(1);
        Assert.AreEqual(Color.Red, page.OnClick1.GetAttributes().Style.BackgroundColor);
        Assert.AreNotEqual(Color.Red, page.OnClick2.GetAttributes().Style.BackgroundColor);

        page.Animation1.OnMouseOver.Ended.Register();
        page.Animation1.OnMouseOver.Play();
        page.Animation1.OnMouseOver.Ended.Wait(1);
        Assert.AreEqual(Color.Red, page.OnMouseOver1.GetAttributes().Style.BackgroundColor);
        Assert.AreNotEqual(Color.Red, page.OnMouseOver2.GetAttributes().Style.BackgroundColor);

        page.Animation1.OnMouseOut.Ended.Register();
        page.Animation1.OnMouseOut.Play();
        page.Animation1.OnMouseOut.Ended.Wait(1);
        Assert.AreEqual(Color.Red, page.OnMouseOut1.GetAttributes().Style.BackgroundColor);
        Assert.AreNotEqual(Color.Red, page.OnMouseOut2.GetAttributes().Style.BackgroundColor);

        page.Animation1.OnHoverOver.Ended.Register();
        page.Animation1.OnHoverOver.Play();
        page.Animation1.OnHoverOver.Ended.Wait(1);
        Assert.AreEqual(Color.Red, page.OnHoverOver1.GetAttributes().Style.BackgroundColor);
        Assert.AreNotEqual(Color.Red, page.OnHoverOver2.GetAttributes().Style.BackgroundColor);

        page.Animation1.OnHoverOut.Ended.Register();
        page.Animation1.OnHoverOut.Play();
        page.Animation1.OnHoverOut.Ended.Wait(1);
        Assert.AreEqual(Color.Red, page.OnHoverOut1.GetAttributes().Style.BackgroundColor);
        Assert.AreNotEqual(Color.Red, page.OnHoverOut2.GetAttributes().Style.BackgroundColor);
    }
}