package com.aptl.services;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.view.View;

public class MainActivity extends Activity
        implements ServiceConnection, MyLocalService.Callback {
    private MyLocalService mService;

    /**
     * Wywoywana przy pierwszym utworzeniu aktywnoci.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main_activity);
    }

    @Override
    protected void onResume() {
        super.onResume();
        Intent bindIntent = new Intent(this, MyLocalService.class);
        bindService(bindIntent, this, BIND_AUTO_CREATE);
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mService != null) {
            mService.setCallback(null); // wane, aby zapobiec wyciekowi pamici
            unbindService(this);
        }
    }

    public void onTriggerLongRunningOperation(View view) {
        if(mService != null) {
            mService.performLongRunningOperation(new MyComplexDataObject());
        }
    }

    @Override
    public void onOperationProgress(int progress) {
        // DO ZROBIENIA: aktualizacja postpu w interfejsie uytkownika...
    }

    @Override
    public void onOperationCompleted(MyComplexResult complexResult) {
        // DO ZROBIENIA: wywietlenie wyniku uytkownikowi...
    }

    @Override
    public void onServiceConnected(ComponentName componentName,
                                   IBinder iBinder) {
        mService = ((MyLocalService.LocalBinder) iBinder).getService();
        mService.setCallback(this);

        // Gdy mamy referencj do usugi, moemy zaktualizowa interfejs uytkownika i 
        // wczy przyciski, ktre w przeciwnym razie powinny by wyczone.
        findViewById(R.id.trigger_operation_button).setEnabled(true);
    }

    @Override
    public void onServiceDisconnected(ComponentName componentName) {
        // wyczenie przycisku, poniewa tracimy referencj do usugi
        findViewById(R.id.trigger_operation_button).setEnabled(false);
        mService = null;
    }
}
