package com.apptl.networking;

import android.util.Base64;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;

/**
 * @author Erik Hellman
 */
public class HttpPostFile {
    private static final long MAX_FIXED_SIZE = 1024 * 1024 * 5;
    private static final String CRLF = "\r\n";

    public int postFileToURL(File file, String mimeType, URL url)
            throws IOException {
        DataOutputStream requestData = null;
        try {
            long size = file.length();
            String fileName = file.getName();

            // utworzenie losowego acucha granicznego
            Random random = new Random();
            byte[] randomBytes = new byte[16];
            random.nextBytes(randomBytes);
            String boundary = Base64.
                    encodeToString(randomBytes, Base64.NO_WRAP);

            HttpURLConnection urlConnection
                    = (HttpURLConnection) url.openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.setDoOutput(true);
            urlConnection.setRequestMethod("POST");

            // ustawienie nagwkw HTTP
            urlConnection.setRequestProperty("Connection", "Keep-Alive");
            urlConnection.setRequestProperty("Cache-Control", "no-cache");
            urlConnection.setRequestProperty("Content-Type",
                    "multipart/form-data;boundary=" + boundary);

            // Jeli wikszy ni MAX_FIXED_SIZE, zastosuj strumieniowanie po kawaku.
            if (size > MAX_FIXED_SIZE) {
                urlConnection.setChunkedStreamingMode(0);
            } else {
                urlConnection.setFixedLengthStreamingMode((int) size);
            }

            // otwarcie pliku do odczytu...
            FileInputStream fileInput = new FileInputStream(file);
            // otwarcie poczenia z serwerem...
            OutputStream outputStream = urlConnection.getOutputStream();
            requestData = new DataOutputStream(outputStream);

            // zapisanie pierwszej granicy dla tego pliku
            requestData.writeBytes("--" + boundary + CRLF);
            // przekazanie serwerowi nazwy pliku...
            requestData.writeBytes("Content-Disposition: form-data; name=\""
                    + fileName + "\";filename=\"" + fileName + CRLF);
            // ...i jego typu MIME
            requestData.writeBytes("Content-Type: " + mimeType + CRLF);

            // odczytanie lokalnego pliku i zapis na serwerze w jednej ptli
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fileInput.read(buffer)) != -1) {
                requestData.write(buffer, 0, bytesRead);
            }

            // zapis granicy wskazujcej koniec pliku
            requestData.writeBytes(CRLF);
            requestData.writeBytes("--" + boundary + "--" + CRLF);
            requestData.flush();

            return urlConnection.getResponseCode();
        } finally {
            if (requestData != null) {
                requestData.close();
            }
        }
    }

}
