package com.aptl.chapter8;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;

/**
 *
 * @author Erik Hellman
 */
public class NetworkListener extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();

        if(ConnectivityManager.CONNECTIVITY_ACTION.equals(action)) {

        } else if(WifiManager.WIFI_STATE_CHANGED_ACTION.equals(action)) {
            // Wi-Fi jest wczone, wyczone, wcza si, wycza si lub jego stan jest nieznany
            int state = intent.getIntExtra(WifiManager.EXTRA_WIFI_STATE);
            // DO ZROBIENIA: obsuga zmiany ustawie Wi-Fi...
        } else if(WifiManager.NETWORK_STATE_CHANGED_ACTION.equals(action)) {
            NetworkInfo networkInfo = intent.getParcelableExtra(WifiManager.EXTRA_NETWORK_INFO);
            if (networkInfo.getState().equals(NetworkInfo.State.CONNECTED)) {
                WifiInfo wifiInfo = intent.getParcelableExtra(WifiManager.EXTRA_WIFI_INFO);
                // DO ZROBIENIA: obsuga zmiany stanu poczenia Wi-Fi...
            } else if (networkInfo.getState().equals(NetworkInfo.State.DISCONNECTED)) {
                // DO ZROBIENIA: obsuga rozczania z Wi-Fi
            }
        }
    }
}
