package com.apptl.chapter2.allocations;

/**
 * @author Erik Hellman
 */
public final class Pair {
    public int firstValue;
    public int secondValue;

    // Odwoanie do nastpnego obiektu w puli
    private Pair next;

    // Blokada do synchronizacji
    private static final Object sPoolSync = new Object();

    // Pierwszy dostpny w puli obiekt
    private static Pair sPool;

    private static int sPoolSize = 0;
    private static final int MAX_POOL_SIZE = 50;

    /**
     * Przepuszcza tylko nowe obiekty z obtain()
     */
    private Pair() { }

    /**
     * Zwraca odzyskany obiekt lub nowy obiekt, jeli pula jest pusta
     */
    public static Pair obtain() {
        synchronized (sPoolSync) {
            if (sPool != null) {
                Pair m = sPool;
                sPool = m.next;
                m.next = null;
                sPoolSize--;
                return m;
            }
        }
        return new Pair();
    }

    /**
     * Odzyskuje ten obiekt do ponownego uytku. Po wywoaniu tej metody
     * trzeba zwolni wszystkie odwoania do tego egzemplarza.
     */
    public void recycle() {
        synchronized (sPoolSync) {
            if (sPoolSize < MAX_POOL_SIZE) {
                next = sPool;
                sPool = this;
                sPoolSize++;
            }
        }
    }
}
