/*
Zadania z rozdziau 1.

Pyty {ID pyty, ID wykonawcy, ID gatunku, Czas trwania, Opinia}
Wykonawcy {ID wykonawcy, Nazwa wykonawcy, ID kraju}
Gatunki {ID gatunku, Nazwa gatunku}
Kraje {ID kraju, Nazwa kraju}

Autorzy {ID autora, Imi, Nazwisko}
Ksiki (ID ksiki, Tytu}
AutorKsiaka {ID autora, ID ksiki}

Uczniowie {Ucze ID, Imi, Nazwisko, Adres ID, Uwagi}
Oceny {Ocena ID, Ocena}
UczniowieOceny {Ucze ID, Ocena ID, Data wystawienia oceny}
Adresy {Adres ID, Miasto, Kod pocztowy, Ulica i nr domu} 

Zadania z rozdziau 2.

SELECT *
FROM Osoby
WHERE Nazwisko = 'Nowak';

SELECT * 
FROM Pracownicy 
WHERE login = '' and haslo = '';

SELECT * 
FROM Pracownicy
WHERE login = '';
DROP TABLE Dane--' and txtHaslo = ''

SELECT * 
FROM Pracownicy 
WHERE login = ''OR 1=1--' and txtHaslo = '';

*/

--Zadania z rozdziau 3.

USE AdventureWorks
GO

SELECT Name, ListPrice*1.20 AS SugerowanaCena, DATEDIFF(WEEK,SellStartDate,SellEndDate)
FROM Production.Product;
SELECT Name, ListPrice*1.20 AS SugerowanaCena, DATEDIFF(WEEK,SellStartDate,COALESCE(SellEndDate,GETDATE()))
FROM Production.Product;

SELECT 'Produkt ' + Name, 'kosztuje', ROUND(ListPrice,1), ListPrice
FROM Production.Product;
SELECT 'Produkt ' + Name, 'kosztuje', ROUND(ListPrice,1), ListPrice
FROM Production.Product
ORDER BY ListPrice DESC;

SELECT OrderDate
FROM Sales.SalesOrderHeader
ORDER BY OrderDate DESC;
SELECT LEFT(OrderDate,11)
FROM Sales.SalesOrderHeader
ORDER BY OrderDate DESC;
SELECT DISTINCT LEFT(OrderDate,11)
FROM Sales.SalesOrderHeader
ORDER BY OrderDate DESC;
SELECT DISTINCT LEFT(OrderDate,11)
FROM Sales.SalesOrderHeader
ORDER BY LEFT(OrderDate,11) DESC;
SELECT DISTINCT YEAR(OrderDate)+'-'+MONTH(OrderDate)+'-'+DAY(OrderDate)
FROM Sales.SalesOrderHeader
ORDER BY YEAR(OrderDate)+'-'+MONTH(OrderDate)+'-'+DAY(OrderDate) DESC;
SELECT DISTINCT CAST(YEAR(OrderDate) AS CHAR(4))+'-'+CAST(MONTH(OrderDate) AS VARCHAR(2)) +'-'+CAST(DAY(OrderDate) AS VARCHAR(2))
FROM Sales.SalesOrderHeader
ORDER BY CAST(YEAR(OrderDate) AS CHAR(4))+'-'+CAST(MONTH(OrderDate) AS VARCHAR(2)) +'-'+CAST(DAY(OrderDate) AS VARCHAR(2)) DESC;

SELECT SpecialOfferID, MaxQty
FROM Sales.SpecialOffer
ORDER BY MaxQty;
SELECT SpecialOfferID, MaxQty, CASE
  WHEN MaxQty IS NULL THEN 1
  ELSE 0
END
FROM Sales.SpecialOffer;
SELECT SpecialOfferID, MaxQty
FROM Sales.SpecialOffer
ORDER BY CASE 
  WHEN MaxQty IS NULL THEN 1
  ELSE 0
END;
SELECT SpecialOfferID, MaxQty
FROM Sales.SpecialOffer
ORDER BY CASE 
  WHEN MaxQty IS NULL THEN 1
  ELSE 0
END,MaxQty;

--Zadania z rozdziau 4.

SELECT *
FROM Production.Product
WHERE StandardCost*2<ListPrice
AND ProductNumber LIKE '%S' OR ProductNumber LIKE '%L';
SELECT Name
FROM Production.Product
WHERE StandardCost*2<ListPrice
AND (ProductNumber LIKE '%S' OR ProductNumber LIKE '%L');
SELECT Name
FROM Production.Product
WHERE StandardCost*2<ListPrice
AND RIGHT(ProductNumber,1) IN ('L','S');

SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '20030101' AND '20030401';
SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '20030101' AND '20030331';
SELECT TOP 5 SalesOrderID, TotalDue
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '20030101' AND '20030331'
ORDER BY TotalDue DESC;
SELECT TOP 5 PERCENT WITH TIES SalesOrderID, TotalDue
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '20030101' AND '20030331'
ORDER BY TotalDue DESC;

SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID<=100;
SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID<=100 AND SalesPersonID>270;
SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID<=100 AND SalesPersonID>270
AND SalesOrderNumber LIKE '%[1-5]';

SELECT Name
FROM Production.Product
WHERE ProductID=CAST(RAND()*999 AS INT);
SELECT TOP 1 Name
FROM Production.Product;
SELECT TOP 1 Name
FROM Production.Product
ORDER BY RAND();
SELECT TOP 1 Name
FROM Production.Product
ORDER BY NEWID();

--Zadania z rozdziau 5.

SELECT P.Name
FROM Production.Product AS P JOIN Sales.SalesTerritory AS T 
ON P.ProductID = T.TerritoryID;
SELECT P.Name
FROM Sales.SalesOrderHeader AS OH 
JOIN Sales.SalesOrderDetail OD 
ON OH.SalesOrderID = OD.SalesOrderID 
JOIN Production.Product AS P 
ON OD.ProductID = P.ProductID 
JOIN Sales.SalesTerritory AS T 
ON OH.TerritoryID = T.TerritoryID 
WHERE T.Name = 'France';
SELECT DISTINCT P.Name
FROM Sales.SalesOrderHeader AS OH 
JOIN Sales.SalesOrderDetail OD 
ON OH.SalesOrderID = OD.SalesOrderID 
JOIN Production.Product AS P 
ON OD.ProductID = P.ProductID 
JOIN Sales.SalesTerritory AS T 
ON OH.TerritoryID = T.TerritoryID 
WHERE T.Name = 'France'
ORDER BY P.Name;

SELECT C.CustomerID
FROM Sales.Customer AS C JOIN Sales.SalesOrderHeader AS OH
ON C.CustomerID = OH.CustomerID
WHERE OH.CustomerID IS NULL;
SELECT C.CustomerID
FROM Sales.Customer AS C LEFT OUTER JOIN Sales.SalesOrderHeader AS OH
ON C.CustomerID = OH.CustomerID
WHERE OH.CustomerID IS NULL;

SELECT OH.SalesPersonID, SP.TerritoryID, OH.TerritoryID, OH.SalesOrderID
FROM Sales.SalesOrderHeader AS OH JOIN Sales.SalesPerson AS SP
ON OH.SalesPersonID = SP.SalesPersonID;
SELECT OH.SalesPersonID, SP.TerritoryID, OH.TerritoryID, OH.SalesOrderID
FROM Sales.SalesOrderHeader AS OH JOIN Sales.SalesPerson AS SP
ON OH.SalesPersonID = SP.SalesPersonID
AND OH.TerritoryID <> SP.TerritoryID;
SELECT OH.SalesPersonID, SP.TerritoryID, OH.TerritoryID, OH.SalesOrderID
FROM Sales.SalesOrderHeader AS OH JOIN Sales.SalesPerson AS SP
ON OH.SalesPersonID = SP.SalesPersonID
AND (OH.TerritoryID <> SP.TerritoryID OR SP.TerritoryID IS NULL)
ORDER BY OH.SalesPersonID;

SELECT SalesOrderID, TotalDue, 'Due'
FROM Sales.SalesOrderHeader
WHERE TotalDue > 100000;
SELECT SalesOrderID, TotalDue, 'Mae'
FROM Sales.SalesOrderHeader
WHERE TotalDue <= 100000;
SELECT SalesOrderID, TotalDue, 'Duze'
FROM Sales.SalesOrderHeader
WHERE TotalDue > 100000
UNION ALL
SELECT SalesOrderID, TotalDue, 'Male'
FROM Sales.SalesOrderHeader
WHERE TotalDue <= 100000;

--Zadania z rozdziau 6.

SELECT MAX(TotalDue)
FROM Sales.SalesOrderHeader;
SELECT MAX(TotalDue)
FROM Sales.SalesOrderHeader
GROUP BY OrderDate;
SELECT MAX(TotalDue)
FROM Sales.SalesOrderHeader
GROUP BY OrderDate,SalesPersonID;
SELECT OrderDate,SalesPersonID, MAX(TotalDue)
FROM Sales.SalesOrderHeader
GROUP BY OrderDate,SalesPersonID;

SELECT PM.Name, P.ProductID
FROM Production.Product P JOIN Production.ProductModel PM
ON P.ProductModelID=PM.ProductModelID;
SELECT PM.Name, COUNT(P.ProductID)
FROM Production.Product P JOIN Production.ProductModel PM
ON P.ProductModelID=PM.ProductModelID
GROUP BY PM.Name;
SELECT PM.Name, COUNT(P.ProductID)
FROM Production.Product P JOIN Production.ProductModel PM
ON P.ProductModelID=PM.ProductModelID
GROUP BY PM.Name
HAVING COUNT(P.ProductID)>10;

SELECT [Group], Name
FROM Sales.SalesTerritory 
ORDER BY [Group];
SELECT [Group], Name,
SUM(salesytd) OVER (PARTITION BY [Group]) 
FROM Sales.SalesTerritory 
ORDER BY [Group];
SELECT [Group], Name,
SUM(salesytd) OVER (PARTITION BY [Group]) ,
SUM(salesytd) OVER (PARTITION BY [Group],Name) 
FROM Sales.SalesTerritory 
ORDER BY [Group];
SELECT [Group], Name,
SUM(salesytd) OVER (PARTITION BY [Group]) ,
SUM(salesytd) OVER (PARTITION BY [Group],Name),
(SUM(salesytd) OVER (PARTITION BY [Group], [Name]) / SUM(salesytd) OVER (PARTITION BY [Group])) 
FROM Sales.SalesTerritory 
ORDER BY [Group];
SELECT [Group], Name,
SUM(salesytd) OVER (PARTITION BY [Group]) ,
SUM(salesytd) OVER (PARTITION BY [Group],Name),
(SUM(salesytd) OVER (PARTITION BY [Group], [Name]) / SUM(salesytd) OVER (PARTITION BY [Group])) * 100.0
FROM Sales.SalesTerritory 
ORDER BY [Group];

CREATE TABLE #MiesiecznaSprzedaz 
(CustomerID int NOT NULL, 
OrderMonth int NOT NULL,
SubTotal money NOT NULL);
GO
INSERT #MiesiecznaSprzedaz 
SELECT CustomerID, DATEPART(m, OrderDate), 
SubTotal FROM Sales.SalesOrderHeader 
WHERE CustomerID <5;
SELECT * 
FROM #MiesiecznaSprzedaz 
PIVOT (SUM(SubTotal) 
FOR CustomerID IN 
([1], [2], [3], [4])) 
AS piv;
SELECT * 
FROM #MiesiecznaSprzedaz 
PIVOT (SUM(SubTotal) 
FOR OrderMonth IN 
([1], [2], [3], [4], [5], [6], [7], [8], [9], [10], [11], [12])) 
AS piv;


--Zadania z rozdziau 7.

SELECT ContactID
FROM Person.Contact
WHERE LastName = 'Verdad';
SELECT SalesOrderID
FROM Sales.SalesOrderHeader
WHERE ContactID = 
  (SELECT ContactID
  FROM Person.Contact
  WHERE LastName = 'Verdad');

SELECT TOP 10 S.SalesOrderID 
FROM Sales.SalesOrderHeader S 
GROUP BY S.SalesOrderID
ORDER BY SUM(TotalDue) DESC;
SELECT TOP 5 OH.SalesOrderID, SUM(TotalDue) 
FROM Sales.SalesOrderHeader OH
GROUP BY OH.SalesOrderID
ORDER BY SUM(TotalDue) DESC;
SELECT TOP 5 OH.SalesOrderID, SUM(TotalDue) 
FROM Sales.SalesOrderHeader OH 
WHERE OH.SalesOrderID NOT IN
  (SELECT TOP 10 S.SalesOrderID 
  FROM Sales.SalesOrderHeader S 
  GROUP BY S.SalesOrderID
  ORDER BY SUM(TotalDue) DESC)
GROUP BY OH.SalesOrderID
ORDER BY SUM(TotalDue) DESC;

SELECT MAX(OrderDate)
FROM Sales.SalesOrderHeader
GROUP BY MONTH(OrderDate);
SELECT MAX(OrderDate)
FROM Sales.SalesOrderHeader
GROUP BY YEAR(OrderDate), MONTH(OrderDate);
SELECT SalesOrderID,OrderDate,CustomerID
FROM Sales.SalesOrderHeader
WHERE OrderDate IN
(SELECT MAX(OrderDate)
FROM Sales.SalesOrderHeader
GROUP BY YEAR(OrderDate), MONTH(OrderDate));

SELECT SalesPersonID, COUNT(*)
FROM Sales.SalesOrderHeader
GROUP BY SalesPersonID;
WITH Sprzedaz (SalesPersonID, LiczbaZamowien)
AS(SELECT SalesPersonID, COUNT(*)
FROM Sales.SalesOrderHeader
GROUP BY SalesPersonID)
SELECT E.EmployeeID, S.LiczbaZamowien,E.ManagerID
FROM HumanResources.Employee AS E 
JOIN Sprzedaz AS S 
ON E.EmployeeID = S.SalesPersonID;
WITH Sprzedaz (SalesPersonID, LiczbaZamowien)
AS(SELECT SalesPersonID, COUNT(*)
FROM Sales.SalesOrderHeader
GROUP BY SalesPersonID)
SELECT E.EmployeeID, S.LiczbaZamowien,E.ManagerID, M.LiczbaZamowien
FROM HumanResources.Employee AS E 
JOIN Sprzedaz AS S 
ON E.EmployeeID = S.SalesPersonID 
JOIN Sprzedaz AS M 
ON E.ManagerID = M.SalesPersonID
ORDER BY E.EmployeeID;
WITH Sprzedaz (SalesPersonID, LiczbaZamowien)
AS(SELECT SalesPersonID, COUNT(*)
FROM Sales.SalesOrderHeader
GROUP BY SalesPersonID)
SELECT E.EmployeeID, S.LiczbaZamowien,E.ManagerID, OM.LiczbaZamowien
FROM HumanResources.Employee AS E 
JOIN Sprzedaz AS S 
ON E.EmployeeID = S.SalesPersonID 
LEFT OUTER JOIN Sprzedaz AS OM 
ON E.ManagerID = OM.SalesPersonID
ORDER BY E.EmployeeID;

--Zadania z rozdziau 8.

SELECT ListPrice,Weight
FROM Production.Product
WHERE ProductSubcategoryID=5;
UPDATE Production.Product
SET ListPrice *= .75, Weight +=5
WHERE ProductSubcategoryID=5
SELECT ListPrice,Weight
FROM Production.Product
WHERE ProductSubcategoryID=5;

DELETE FROM Production.Product
WHERE ProductID=950;
DELETE FROM Production.ProductCostHistory
WHERE ProductID=950;
DELETE FROM Production.Product
WHERE ProductID=950;
DELETE FROM Production.ProductInventory
WHERE ProductID=950;
DELETE FROM Production.ProductListPriceHistory
WHERE ProductID=950;
DELETE FROM Production.ProductProductPhoto
WHERE ProductID=950;
DELETE FROM Sales.SpecialOfferProduct
WHERE ProductID=950;
DELETE FROM Sales.SalesOrderDetail
WHERE ProductID=950;
DELETE FROM Production.TransactionHistory
WHERE ProductID=950;
DELETE FROM Production.WorkOrder
WHERE ProductID=950;
DELETE FROM Production.WorkOrderRouting
WHERE ProductID=950;
DELETE FROM Production.WorkOrder
WHERE ProductID=950;
DELETE FROM Production.BillOfMaterials
WHERE ProductAssemblyID=950
OR ComponentID=950;
DELETE FROM Production.Product
WHERE ProductID=950;

SELECT EmployeeID,FirstName,LastName
FROM Person.Contact AS C JOIN HumanResources.Employee AS E
ON C.ContactID=E.ContactID
WHERE Gender ='F';
SELECT EmployeeID,FirstName, LastName
INTO #Panie
FROM Person.Contact AS C JOIN HumanResources.Employee AS E
ON C.ContactID=E.ContactID
WHERE Gender ='F';
WITH Pracownicy AS
(SELECT EmployeeID,FirstName,LastName
FROM Person.Contact AS C JOIN HumanResources.Employee AS E
ON C.ContactID=E.ContactID)
MERGE INTO #Panie AS D
USING Pracownicy AS Z
ON (D.EmployeeID = Z.EmployeeID)
WHEN MATCHED AND D.FirstName <>Z.FirstName THEN
  UPDATE SET D.FirstName = Z.FirstName
WHEN NOT MATCHED THEN
  INSERT (EmployeeID,FirstName,LastName)
  VALUES (Z.EmployeeID,Z.FirstName,Z.LastName)
WHEN SOURCE NOT MATCHED THEN
  DELETE;

--Zadania z rozdziau 10.
USE Test
GO
CREATE TABLE Uczestnicy(
ID INT IDENTITY PRIMARY KEY,
Imie VARCHAR(30) NOT NULL,
Nazwisko VARCHAR (40) NOT NULL,
EMail VARCHAR(50) NOT NULL,
Telefon VARCHAR(15) NOT NULL,
Kod CHAR(5) NOT NULL UNIQUE,
Miasto VARCHAR(30) NULL DEFAULT 'Katowice',
Wiek TINYINT NULL CHECK (Wiek BETWEEN 5 AND 105),
Plec CHAR(1) NULL CHECK (Plec IN ('K','M')));

CREATE TABLE Autorzy (
IDAutora INT IDENTITY PRIMARY KEY,
Imie VARCHAR(30) NOT NULL,
Nazwisko VARCHAR (40) NOT NULL);
CREATE TABLE Ksiazki (
IDKsiazki INT IDENTITY PRIMARY KEY,
Tytul VARCHAR(30) NOT NULL,
DataWydania DATE NOT NULL);
CREATE TABLE AutorzyKsiazki (
IDAutora INT REFERENCES Autorzy,
IDKsiazki INT REFERENCES Ksiazki);

CREATE TABLE Produkcja.Modele(
Nazwa VARCHAR (5) PRIMARY KEY);
GO
INSERT INTO Produkcja.Modele
VALUES ('BRAK!');
ALTER TABLE Produkcja.Towary 
ADD Model VARCHAR(5) REFERENCES Produkcja.Modele; 
GO
UPDATE Produkcja.Towary 
SET Model = 'BRAK!';
ALTER TABLE Produkcja.Towary
ALTER COLUMN Model VARCHAR(5) NOT NULL;
GO

--Zadania z rozdziau 11.
USE AdventureWorks
GO

SELECT C.Name AS NazwaKategorii, SC.Name AS NazwaPodkategorii, P.Name, P.ListPrice*0.22
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID = P.ProductSubcategoryID
JOIN Production.ProductCategory AS C
ON C.ProductCategoryID = SC.ProductCategoryID;
GO
CREATE VIEW vNazwy AS
SELECT C.Name AS NazwaKategorii, SC.Name AS NazwaPodkategorii, P.Name, P.ListPrice*0.22 AS VAT
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID = P.ProductSubcategoryID
JOIN Production.ProductCategory AS C
ON C.ProductCategoryID = SC.ProductCategoryID;
GO
CREATE VIEW vNazwy1 (NazwaKategorii, NazwaPodkategorii, NazwaProduktu, VAT) AS
SELECT C.Name, SC.Name AS NazwaPodkategorii, P.Name, P.ListPrice*0.22
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID = P.ProductSubcategoryID
JOIN Production.ProductCategory AS C
ON C.ProductCategoryID = SC.ProductCategoryID;
GO

CREATE UNIQUE INDEX IX_SalesOrderDetailSO
ON Sales.SalesOrderDetail (SpecialOfferID,UnitPrice);


--Zadania z rozdziau 12.

GRANT SELECT,INSERT,UPDATE,DELETE,EXECUTE
ON Schema::Person
TO Dev;

REVOKE SELECT,UPDATE
ON Person.Contact(Phone)
FROM Dev;
DENY SELECT,UPDATE
ON Person.Contact(Phone)
TO Dev;

GRANT CONTROL
ON Person.Address
TO Marcin
WITH GRANT OPTION;

