USE AdventureWorks
GO

SELECT ProductID,Name,ListPrice,SafetyStockLevel
FROM Production.Product
WHERE SafetyStockLevel<10;
GO

CREATE VIEW Production.vNiskieStany AS
SELECT ProductID,Name,ListPrice,SafetyStockLevel
FROM Production.Product
WHERE SafetyStockLevel<10;
GO

SELECT TOP 4 Name,ListPrice,SafetyStockLevel
FROM Production.vNiskieStany 
ORDER BY SafetyStockLevel;
GO

CREATE VIEW HumanResources.vPracownicy AS 
SELECT TOP 100 PERCENT 
c.LastName, e.EmployeeID, c.Title, c.FirstName, c.MiddleName, e.Title AS Stanowisko, c.Phone, c.EmailAddress, COALESCE (a.AddressLine1,'') + COALESCE (a.AddressLine2,'') Adres, a.City, sp.Name Stan, a.PostalCode, cr.Name AS Region ,c.AdditionalContactInfo 
FROM HumanResources.Employee e INNER JOIN Person.Contact c ON c.ContactID = e.ContactID
JOIN HumanResources.EmployeeAddress ea ON e.EmployeeID = ea.EmployeeID 
JOIN Person.Address a ON ea.AddressID = a.AddressID
JOIN Person.StateProvince sp ON sp.StateProvinceID = a.StateProvinceID
JOIN Person.CountryRegion cr ON cr.CountryRegionCode = sp.CountryRegionCode
ORDER BY c.LastName;
GO

SELECT LastName,FirstName,MiddleName,Stanowisko
FROM HumanResources.vPracownicy;

SELECT LastName,FirstName,MiddleName,Stanowisko
FROM HumanResources.vPracownicy
ORDER BY LastName;
GO

ALTER VIEW HumanResources.vPracownicy AS 
SELECT c.LastName, e.EmployeeID, c.Title, c.FirstName, c.MiddleName, e.Title AS Stanowisko, c.Phone, c.EmailAddress, COALESCE (a.AddressLine1,'') + COALESCE (a.AddressLine2,'') Adres, a.City, sp.Name Stan, a.PostalCode, cr.Name AS Region ,c.AdditionalContactInfo
FROM HumanResources.Employee e INNER JOIN Person.Contact c ON c.ContactID = e.ContactID
JOIN HumanResources.EmployeeAddress ea ON e.EmployeeID = ea.EmployeeID 
JOIN Person.Address a ON ea.AddressID = a.AddressID
JOIN Person.StateProvince sp ON sp.StateProvinceID = a.StateProvinceID
JOIN Person.CountryRegion cr ON cr.CountryRegionCode = sp.CountryRegionCode;
GO

CREATE VIEW Sales.vNiskieStanySprz AS
SELECT N.ProductID, N.Name, N.ListPrice, OD.SalesOrderID, OD.LineTotal
FROM Production.vNiskieStany AS N
JOIN Sales.SalesOrderDetail AS OD
ON N.ProductID = N.ProductID;
GO

SET SHOWPLAN_TEXT ON;
GO
SELECT * 
FROM Sales.vNiskieStanySprz
WHERE Name = 'Bike Wash - Dissolver';
GO
SET SHOWPLAN_TEXT OFF;
GO

CREATE VIEW Sales.vDziennyObrot (Data, Klientow, Sprzedawcow, Zamowien, Srednia, Suma) AS
SELECT OrderDate, COUNT (DISTINCT CustomerID), COUNT (DISTINCT SalesPersonID), COUNT(SalesOrderID), AVG (TotalDue), SUM(TotalDue)
FROM Sales.SalesOrderHeader
GROUP BY OrderDate;
GO

SELECT *
FROM Sales.vDziennyObrot 
WHERE Srednia>15000 AND Klientow>200;
GO

CREATE VIEW Sales.vSalesTaxRate AS
SELECT SalesTaxRateID, StateProvinceID, TaxType, TaxRate, Name
FROM Sales.SalesTaxRate
WHERE TaxType>1;
GO

INSERT INTO Sales.vSalesTaxRate (StateProvinceID,TaxType, TaxRate, Name)
VALUES (2,2,DEFAULT,'Canadian GST');
SELECT *
FROM Sales.vSalesTaxRate 
WHERE StateProvinceID<=2;

INSERT INTO Sales.vSalesTaxRate (StateProvinceID,TaxType, TaxRate, Name)
VALUES (2,1,30,'Canadian GST')
SELECT *
FROM Sales.vSalesTaxRate 
WHERE StateProvinceID<=2;

SELECT *
FROM Sales.vSalesTaxRate 
WHERE SalesTaxRateID=29;
UPDATE Sales.vSalesTaxRate
SET TaxType=1
WHERE SalesTaxRateID=29;

SELECT *
FROM Sales.vSalesTaxRate 
WHERE SalesTaxRateID=29;
GO

ALTER VIEW Sales.vSalesTaxRate AS
SELECT SalesTaxRateID, StateProvinceID, TaxType, TaxRate, Name
FROM Sales.SalesTaxRate
WHERE TaxType>1
WITH CHECK OPTION;
GO

INSERT INTO Sales.vSalesTaxRate (StateProvinceID,TaxType, TaxRate, Name)
VALUES (22,1,30,'Test');
GO

CREATE INDEX IX_SalesOrderDetailUnitPrice
ON Sales.SalesOrderDetail (UnitPrice);

SELECT UnitPrice,OrderQty
FROM Sales.SalesOrderDetail
WHERE UnitPrice BETWEEN 100 AND 115;

SELECT UnitPrice,OrderQty
FROM Sales.SalesOrderDetail
WHERE UnitPrice BETWEEN 100 AND 150;

DROP INDEX IX_SalesOrderDetailUnitPrice
ON Sales.SalesOrderDetail;
CREATE INDEX IX_SalesOrderDetailUnitPrice
ON Sales.SalesOrderDetail (UnitPrice,OrderQty);
GO

CREATE UNIQUE INDEX UX_ProductNameListPrice
ON Production.Product (Name,ListPrice);

ALTER INDEX ALL
ON HumanResources.Department
REBUILD;

ALTER INDEX IX_Employee_ManagerID
ON HumanResources.Employee
REORGANIZE;


SELECT C.Name, SC.Name, P.Name, P.ListPrice*0.22
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID = P.ProductSubcategoryID
JOIN Production.ProductCategory AS C
ON C.ProductCategoryID = SC.ProductCategoryID;

CREATE VIEW Sales.vSalesContact AS
SELECT DISTINCT FirstName + ' ' + LastName AS Osoba,SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader AS OH RIGHT OUTER JOIN Person.Contact AS P
ON OH.ContactID = P.ContactID;
