USE master;
CREATE DATABASE Test;
EXEC sp_helpdb 'Test';
GO

CREATE DATABASE [TestMS] ON PRIMARY 
( NAME = N'TestMS', FILENAME = N'G:\DATA\TestMS.mdf' , SIZE = 2048KB , FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N'TestMS_log', FILENAME = N'G:\DATA\TestMS_log.ldf' , SIZE = 1024KB , FILEGROWTH = 10%)
 COLLATE Polish_CS_AI
GO
ALTER DATABASE [TestMS] SET COMPATIBILITY_LEVEL = 100
ALTER DATABASE [TestMS] SET ANSI_NULL_DEFAULT OFF 
ALTER DATABASE [TestMS] SET ANSI_NULLS OFF 
ALTER DATABASE [TestMS] SET ANSI_PADDING OFF 
ALTER DATABASE [TestMS] SET ANSI_WARNINGS OFF 
ALTER DATABASE [TestMS] SET ARITHABORT OFF 
ALTER DATABASE [TestMS] SET AUTO_CLOSE OFF 
ALTER DATABASE [TestMS] SET AUTO_CREATE_STATISTICS ON 
ALTER DATABASE [TestMS] SET AUTO_SHRINK OFF 
ALTER DATABASE [TestMS] SET AUTO_UPDATE_STATISTICS ON 
ALTER DATABASE [TestMS] SET CURSOR_CLOSE_ON_COMMIT ON 
ALTER DATABASE [TestMS] SET CURSOR_DEFAULT GLOBAL 
ALTER DATABASE [TestMS] SET CONCAT_NULL_YIELDS_NULL OFF 
ALTER DATABASE [TestMS] SET NUMERIC_ROUNDABORT OFF 
ALTER DATABASE [TestMS] SET QUOTED_IDENTIFIER OFF 
ALTER DATABASE [TestMS] SET RECURSIVE_TRIGGERS OFF 
ALTER DATABASE [TestMS] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
ALTER DATABASE [TestMS] SET DATE_CORRELATION_OPTIMIZATION OFF 
ALTER DATABASE [TestMS] SET PARAMETERIZATION SIMPLE 
ALTER DATABASE [TestMS] SET READ_WRITE 
ALTER DATABASE [TestMS] SET RECOVERY SIMPLE 
ALTER DATABASE [TestMS] SET MULTI_USER 
ALTER DATABASE [TestMS] SET PAGE_VERIFY CHECKSUM 
ALTER DATABASE [TestMS] SET ENCRYPTION OFF
USE [TestMS]
IF NOT EXISTS (SELECT name FROM sys.filegroups WHERE is_default=1 AND name = N'PRIMARY') ALTER DATABASE [TestMS] MODIFY FILEGROUP [PRIMARY] DEFAULT
GO

DROP DATABASE TestMS;
GO

USE master;
ALTER DATABASE TestMS
SET SINGLE_USER 
WITH ROLLBACK IMMEDIATE;
DROP DATABASE TestMS;
GO

USE Test;
CREATE TABLE T1 (
ID INT,
Nazwa VARCHAR(50),
Cena MONEY,
DataZakupu DATE);
GO

DROP TABLE T1; 
GO

CREATE SCHEMA Produkcja;
GO
CREATE TABLE Produkcja.Towary (
ID INT IDENTITY,
Nazwa VARCHAR(50),
Cena MONEY,
DataZakupu DATE);
GO

ALTER TABLE Produkcja.Towary 
ADD Kolor VARCHAR(10);
ALTER TABLE Produkcja.Towary 
DROP COLUMN Kolor
GO

ALTER TABLE Produkcja.Towary 
ADD Rabat MONEY NOT NULL;

ALTER TABLE Produkcja.Towary 
ALTER COLUMN Nazwa VARCHAR(50) NOT NULL;

ALTER TABLE Produkcja.Towary 
ALTER COLUMN DataZakupu DATE NULL;
GO

ALTER TABLE Produkcja.Towary 
ADD CONSTRAINT PK_Towary PRIMARY KEY (ID);

CREATE TABLE Produkcja.Czci (
ID INT PRIMARY KEY,
Nazwa VARCHAR(30) NOT NULL);
GO

ALTER TABLE Produkcja.Towary 
DROP CONSTRAINT PK_Towary;
ALTER TABLE Produkcja.Towary 
DROP COLUMN ID;
ALTER TABLE Produkcja.Towary 
ADD ID INT IDENTITY (1,1) CONSTRAINT PK_Towary PRIMARY KEY;
GO

DROP TABLE Produkcja.Czci;
CREATE TABLE Produkcja.Czci (
ID INT IDENTITY (100,1) CONSTRAINT PK_Czesci PRIMARY KEY,
Nazwa VARCHAR(30) NOT NULL);
GO

CREATE TABLE dbo.Znajomi(
Nazwisko VARCHAR(50),
Imi VARCHAR(20),
DataUr DATE,
CONSTRAINT PK_Znajomi PRIMARY KEY (Nazwisko,Imi))
GO

ALTER TABLE Produkcja.Towary 
ADD CONSTRAINT U_NazwaTowaru UNIQUE (Nazwa);  

ALTER TABLE Produkcja.Czci
ADD Kod CHAR(5) NOT NULL CONSTRAINT U_CzesciKod UNIQUE
GO

ALTER TABLE Produkcja.Towary 
ADD CONSTRAINT DF_TowaryData DEFAULT GETDATE() FOR DataZakupu;

ALTER TABLE Produkcja.Czci
ADD Jakosc SMALLINT CONSTRAINT DF_CzesciJakosc DEFAULT 5
GO

ALTER TABLE Produkcja.Czci
ADD CONSTRAINT CK_CzesciJakosc CHECK (Jakosc BETWEEN 0 AND 5);

ALTER TABLE Produkcja.Towary 
ADD DataSprzedazy DATE;
GO
ALTER TABLE Produkcja.Towary 
ADD CONSTRAINT CK_TowaryData CHECK (DataSprzedazy  BETWEEN DataZakupu AND GETDATE());
GO

ALTER TABLE Produkcja.Czci
ADD IDTowaru INT REFERENCES Produkcja.Towary;

ALTER TABLE Produkcja.Czci
DROP CONSTRAINT FK__Czci__IDTowaru__108B795B; --ZA KAZDYM RAZEM ID BEDZIE INNE
ALTER TABLE Produkcja.Czci
DROP COLUMN IDTowaru;
ALTER TABLE Produkcja.Czci
ADD IDTowaru INT CONSTRAINT FK_Towary REFERENCES Produkcja.Towary (ID);
GO

ALTER TABLE Produkcja.Czci
ADD IDCzesci INT CONSTRAINT FK_Czesci REFERENCES Produkcja.Czci;
GO

ALTER TABLE Produkcja.Czci
DROP CONSTRAINT FK_Towary;
ALTER TABLE Produkcja.Czci
ADD CONSTRAINT FK_Towary  FOREIGN KEY (IDTowaru)
REFERENCES Produkcja.Towary
ON UPDATE CASCADE
ON DELETE SET NULL
GO

ALTER TABLE AdventureWorks.Sales.SalesOrderHeader
ADD CONSTRAINT CK_SOHData CHECK (OrderDate >= '2001-07-01');



