USE AdventureWorks;
GO
SELECT Name 
FROM Production.Product
WHERE ListPrice=91.57;
GO

SELECT Name, ListPrice
FROM Production.Product
WHERE ListPrice>3500;
GO

SELECT EmployeeID, VacationHours
FROM HumanResources.Employee
WHERE VacationHours>=97
ORDER BY VacationHours;
GO

SELECT ProductReviewID, ReviewerName, ReviewDate
FROM Production.ProductReview
WHERE MONTH(ReviewDate)=10;
GO

SELECT EmployeeID, VacationHours, SickLeaveHours
FROM HumanResources.Employee
WHERE VacationHours*10<SickLeaveHours;
GO

SELECT Name, ProductSubcategoryID
FROM Production.Product
WHERE ProductSubcategoryID IN(6,7);
GO

SELECT AddressLine1, City
FROM Person.Address
WHERE City IN('Quebec','New York');
GO

SELECT Name, ListPrice
FROM Production.Product
WHERE ListPrice BETWEEN 150 AND 200;
GO

SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '20020613' AND '20020614';
GO

SELECT Name
FROM Production.Product
WHERE LEFT(Name,1) BETWEEN 'A' AND 'B';
GO

SELECT FirstName, LastName, EmailAddress
FROM Person.Contact
WHERE LastName LIKE 'P%a';
GO

SELECT DISTINCT FirstName
FROM Person.Contact
WHERE FirstName LIKE '_r__a';
GO

SELECT Name
FROM Production.Product
WHERE Name LIKE 'W%''%L';
GO

SELECT Title
FROM Production.Document
WHERE DocumentSummary IS NULL;
GO

SELECT ProductID,Name
FROM Production.Product
WHERE ProductSubcategoryID IN (1,2)
AND NOT Class='H'
AND ListPrice BETWEEN 1000 AND 1500
AND Name LIKE 'Road%'
AND SellEndDate IS NULL;
GO

SELECT SalesOrderID
FROM Sales.SalesOrderHeader
WHERE CustomerID IN(564,114)
--OR TotalDue >100000;
GO

SELECT Name,Color,ListPrice
FROM Production.Product
WHERE NOT Color = 'Black'
AND ListPrice >1000;
GO

SELECT Name,Color,ListPrice
FROM Production.Product
WHERE NOT (Color = 'Black'
AND ListPrice >1000);
GO

SELECT ProductSubcategoryID,ListPrice,SellStartDate
FROM Production.Product
WHERE NOT ((SellStartDate = '20010701' AND ProductSubcategoryID >5)
OR ListPrice BETWEEN 50 AND 5000);
GO

SELECT TOP 1 Name, ListPrice
FROM Production.Product;
GO

SELECT TOP 1 Name, ListPrice
FROM Production.Product
ORDER BY ListPrice DESC;
GO

SELECT TOP 1 WITH TIES Name, ListPrice
FROM Production.Product
ORDER BY ListPrice DESC;
GO

SELECT TOP 2 PERCENT WITH TIES EmployeeID, SickLeaveHours
FROM HumanResources.Employee
ORDER BY SickLeaveHours DESC;
GO

SET STATISTICS IO ON;
SELECT *
FROM Person.Contact;
GO

SELECT *
FROM Person.Contact
WHERE LastName ='Abel';
GO

SELECT *
FROM Person.Contact
WHERE EmailAddress ='catherine0@adventure-works.com';
SET STATISTICS IO OFF;
GO

SET STATISTICS IO ON;
SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID =576;

SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID <100;
SET STATISTICS IO OFF;
GO

SET STATISTICS IO ON;
SELECT  SalesOrderID, CustomerID
FROM Sales.SalesOrderHeader
WHERE CustomerID <100;

SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID <100;
SET STATISTICS IO OFF;
GO

SET SHOWPLAN_TEXT ON; 
GO 
SELECT * 
FROM Sales.SalesOrderHeader
WHERE NOT CustomerID >3;
GO
SET SHOWPLAN_TEXT OFF;

SET STATISTICS IO ON;
SELECT * 
FROM Sales.SalesOrderHeader
WHERE CustomerID <2;

SELECT * 
FROM Sales.SalesOrderHeader
WHERE  CustomerID+0 <2;

SELECT *
FROM Sales.SalesOrderHeader 
WHERE SalesOrderNumber='SO43860';

SELECT *
FROM Sales.SalesOrderHeader
WHERE UPPER(SalesOrderNumber)='SO43860';

SELECT *
FROM Sales.SalesOrderHeader 
WHERE SalesOrderNumber = 'SO43860';

SELECT *
FROM Sales.SalesOrderHeader
WHERE SalesOrderNumber = 'SO43860' COLLATE SQL_Latin1_General_CP1_CI_AS;
SET STATISTICS IO OFF;
GO
