USE Northwind;
GO

SELECT [Nazwa produktu]
FROM dbo.Produkty
WHERE [Cena katalowa] =10;


SELECT [Nazwa produktu],[Cena katalowa]
FROM dbo.Produkty
WHERE [Cena katalowa]>50;


SELECT [ID zamwienia], [Data zamwienia]
FROM dbo.Zamwienia
WHERE [Data zamwienia]>='2006-06-01'
ORDER BY [Data zamwienia] DESC;


SELECT [ID zamwienia], [Data zamwienia]
FROM dbo.Zamwienia
WHERE MONTH([Data zamwienia])=1;


SELECT [Kod produktu], [Koszt standardowy], [Cena katalowa]
FROM dbo.Produkty
WHERE [Koszt standardowy]*2<[Cena katalowa];


SELECT [Kod produktu], [Cena katalowa] 
FROM dbo.Produkty
WHERE [Cena katalowa] IN(5,10);


SELECT Nazwisko, Miasto
FROM dbo.Klienci
WHERE Miasto IN('Krakw','Kielce');


SELECT [Kod produktu], [Cena katalowa] 
FROM dbo.Produkty
WHERE [Cena katalowa]  BETWEEN 10 AND 20;


SELECT [ID zamwienia], [Data zamwienia]
FROM dbo.Zamwienia
WHERE [Data zamwienia] BETWEEN '2006-04-22' AND '2006-04-27';


SELECT Nazwisko
FROM dbo.Pracownicy
WHERE LEFT(Nazwisko,1) BETWEEN 'B' AND 'C';


SELECT Nazwisko, Imi
FROM dbo.Pracownicy
WHERE Nazwisko LIKE 'O%a';


SELECT DISTINCT Imi
FROM dbo.Pracownicy
WHERE Imi LIKE '_o___a';


SELECT [Kod produktu]
FROM dbo.Produkty
WHERE [Minimalna ilo do ponowne zamwienia] IS NULL;


SELECT [Kod produktu]
FROM dbo.Produkty
WHERE Kateria IN ('Napoje','Sodycze')
AND NOT [ID dostawcw]='3'
AND [Cena katalowa] BETWEEN 10 AND 30
AND [Nazwa produktu] LIKE 'Northwind Traders C%'
AND Opis IS NULL;


SELECT [ID zamwienia]
FROM dbo.Zamwienia
WHERE [ID klienta] IN(4,8)
--OR  [ID pracownika]=1;


SELECT [ID zamwienia], [Miasto odbiorcy],[Opata za wysyk]
FROM dbo.Zamwienia
WHERE NOT [Miasto odbiorcy] = 'Katowice'
AND [Opata za wysyk] >10;


SELECT [ID zamwienia], [Miasto odbiorcy],[Opata za wysyk]
FROM dbo.Zamwienia
WHERE NOT ([Miasto odbiorcy] = 'Katowice'
AND [Opata za wysyk] >10);


SELECT [Kod produktu], Kateria, [Koszt standardowy], [Minimalna ilo do ponowne zamwienia]
FROM dbo.Produkty
WHERE NOT (([Koszt standardowy] > 20 AND Kateria ='Napoje')
OR [Minimalna ilo do ponowne zamwienia] BETWEEN 10 AND 20);


SELECT ProductSubcateryID,ListPrice,SellStartDate
FROM Production.Product
WHERE NOT ((SellStartDate = '20010701' AND ProductSubcateryID >5)
OR ListPrice BETWEEN 50 AND 5000);


SELECT TOP 1 [Kod produktu],[Cena katalowa]
FROM dbo.Produkty;


SELECT TOP 1 [Kod produktu],[Cena katalowa]
FROM dbo.Produkty
ORDER BY [Cena katalowa];


SELECT TOP 1 WITH TIES [Kod produktu],[Cena katalowa]
FROM dbo.Produkty
ORDER BY [Cena katalowa];


SELECT TOP 5 PERCENT WITH TIES [Kod produktu],[Cena katalowa]
FROM dbo.Produkty
ORDER BY [Cena katalowa] DESC;


SELECT [Kod produktu], [Cena katalowa]
FROM dbo.Produkty
ORDER BY [Cena katalowa] DESC
OFFSET 10 ROWS
FETCH NEXT 5 ROWS ONLY;


DECLARE @Strona TINYINT = 3, @Bieca INT  = 5;
SELECT [Kod produktu], [Cena katalowa] 
FROM dbo.Produkty
ORDER BY [Cena katalowa] DESC  
OFFSET (@Strona * (@Bieca - 1)) ROWS
FETCH NEXT @Strona ROWS ONLY; 

USE AdventureWorks

SET STATISTICS IO ON;
SELECT *
FROM Person.Contact;


SELECT *
FROM Person.Contact
WHERE LastName ='Abel';


SELECT *
FROM Person.Contact
WHERE EmailAddress ='catherine0@adventure-works.com';
SET STATISTICS IO OFF;


SET STATISTICS IO ON;
SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID =576;

SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID <100;
SET STATISTICS IO OFF;


SET STATISTICS IO ON;
SELECT  SalesOrderID, CustomerID
FROM Sales.SalesOrderHeader
WHERE CustomerID <100;

SELECT *
FROM Sales.SalesOrderHeader
WHERE CustomerID <100;
SET STATISTICS IO OFF;


SET SHOWPLAN_TEXT ON; 
 
SELECT * 
FROM Sales.SalesOrderHeader
WHERE NOT CustomerID >3;

SET SHOWPLAN_TEXT OFF;

SET STATISTICS IO ON;
SELECT * 
FROM Sales.SalesOrderHeader
WHERE CustomerID <2;

SELECT * 
FROM Sales.SalesOrderHeader
WHERE  CustomerID+0 <2;

SELECT *
FROM Sales.SalesOrderHeader 
WHERE SalesOrderNumber='SO43860';

SELECT *
FROM Sales.SalesOrderHeader
WHERE UPPER(SalesOrderNumber)='SO43860';

SELECT *
FROM Sales.SalesOrderHeader 
WHERE SalesOrderNumber = 'SO43860';

SELECT *
FROM Sales.SalesOrderHeader
WHERE SalesOrderNumber = 'SO43860' COLLATE SQL_Latin1_General_CP1_CI_AS;
SET STATISTICS IO OFF;

