<?php
require_once dirname(__FILE__) . '/../travelMath.php';
require_once '/PHPUnit/Autoload.php';
/**
 * Klasa testowa dla podrozObliczenia
 */
class podrozObliczeniaTest extends PHPUnit_Framework_TestCase
{
        /**
     * Przygotowuje środowisko do uruchomienia testów.
     */
    protected function setUp()
    {
        parent::setUp ();
    }
    /**
     * Czyści środowisko po wykonaniu testów.
     */
    protected function tearDown()
    {
        parent::tearDown ();
    }
    
    /**
     * Konstruktor klasy testowej
     */
    public function __construct() {
        // TODO Auto-generated constructor
    }

    public function testObliczOdleglosc_bez_roznic() {
        $start = new Lokalizacja(3, 7);
        
        $oczekiwane = 0;
        $otrzymane = PodrozObliczenia::obliczOdleglosc($start, $start);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testObliczOdleglosc_bez_roznic_na_y() {
        $start = new Lokalizacja(5, 7);
        $cel = new Lokalizacja(3, 7);
        
        $oczekiwane = 2;
        $otrzymane = PodrozObliczenia::obliczOdleglosc($start, $cel);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testObliczOdleglosc_bez_roznic_na_x() {
        $start = new Lokalizacja(3, 10);
        $cel = new Lokalizacja(3, 7);
        
        $oczekiwane = 3;
        $otrzymane = PodrozObliczenia::obliczOdleglosc($start, $cel);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testObliczOdleglosc_roznica_na_x_y() {
        $start = new Lokalizacja(6, 7);
        $cel = new Lokalizacja(3, 11);
        
        $oczekiwane = 5;
        $otrzymane = PodrozObliczenia::obliczOdleglosc($start, $cel);
        $this->assertEquals($oczekiwane, $otrzymane, '', 0.01);
    }
    
    public function testObliczKatWStopniach_bez_ruszania() {
        $start = new Lokalizacja(3, 7);
        
        $oczekiwane = null;
        $otrzymane = PodrozObliczenia::obliczKatWStopniach($start, $start);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testObliczKatWStopniach_ruch_w_gore() {
        $start = new Lokalizacja(3, 7);
        $cel = new Lokalizacja(3, 12);
        
        $oczekiwane = 90.0;
        $otrzymane = PodrozObliczenia::obliczKatWStopniach($start, $cel);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testObliczKatWStopniach_ruch_w_dol() {
        $start = new Lokalizacja(3, 12);
        $cel = new Lokalizacja(3, 7);
        
        $oczekiwane = -90.0;
        $otrzymane = PodrozObliczenia::obliczKatWStopniach($start, $cel);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testObliczKatWStopniach_ruch_w_lewo() {
        $start = new Lokalizacja(6, 7);
        $cel = new Lokalizacja(3, 7);
        
        $oczekiwane = 180.0;
        $otrzymane = PodrozObliczenia::obliczKatWStopniach($start, $cel);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testObliczKatWStopniach_ruch_w_prawo() {
        $start = new Lokalizacja(3, 7);
        $cel = new Lokalizacja(6, 7);
        
        $oczekiwane = 0.0;
        $otrzymane = PodrozObliczenia::obliczKatWStopniach($start, $cel);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testObliczKatWStopniach_ruch_polnocny_wschod() {
        //losowe wartości w obu przypadkach powinny być $x2 != $x1 i $y2 != $y1
        $x1 = rand(-25, 15);
        $y1 = rand(-25, 25);
        $x2 = rand(-25, 25);
        $y2 = rand(-25, 25);
        
        while ($x2 == $x1) {
            $x2 = rand(-25, 25);
        }
        while ($y2 == $y1) {
            $y2 = rand(-25, 25);
        }
        
        $start = new Lokalizacja($x1, $y1);
        $cel = new Lokalizacja($x2, $y2);
        
        $oczekiwane = rad2deg(atan(($y2 - $y1) / ($x2 - $x1)));
        $otrzymane = PodrozObliczenia::obliczKatWStopniach($start, $cel);
        $this->assertEquals($oczekiwane, $otrzymane, '', 0.01);
    }
    
    public function testCzyBliskoCelu_x_daleko_blad() {
        $start = new Lokalizacja(3, 9);
        $cel = new Lokalizacja(3.5, 7);
        $krok = 1.0;
        
        $oczekiwane = false;
        $otrzymane = PodrozObliczenia::czyBliskoCelu($start, $cel, $krok);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testCzyBliskoCelu_y_daleko_blad() {
        $start = new Lokalizacja(4.5, 7.5);
        $cel = new Lokalizacja(3.5, 7);
        $krok = 1.0;
        
        $oczekiwane = false;
        $otrzymane = PodrozObliczenia::czyBliskoCelu($start, $cel, $krok);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
    
    public function testCzyBliskoCelu_powinno_przejsc() {
        $start = new Lokalizacja(3, 7.5);
        $cel = new Lokalizacja(3.5, 7);
        $krok = 1.0;
        
        $oczekiwane = true;
        $otrzymane = PodrozObliczenia::czyBliskoCelu($start, $cel, $krok);
        $this->assertEquals($oczekiwane, $otrzymane);
    }
}
?>
