<?php
error_reporting(E_ALL);
require_once ('config.php');
require_once ('location.php');
require_once ('travelView.php');  
require_once ('travelMath.php');

class Podroz
{
    private $start = null;
    private $cel = null;
    private $czas = 0.0;
    
    public function wykonaj(Lokalizacja $start, Lokalizacja $cel) 
    {
        $this->start = $start;
        $this->cel = $cel;
        $this->czas = 0.0;
        
        $kat = PodrozObliczenia::obliczKatWStopniach($start, $cel);
        $kat_w_radianach = deg2rad($kat);
        $odleglosc = PodrozObliczenia::obliczOdleglosc($start, $cel);
        
        PodrozWidok::wyswietlPlanowanaTrase($kat, $odleglosc, $start, $cel);
            
        $ma_opcje = $this->czyMamyOpcje();
        
        if ($ma_opcje) {
            if (ZLA_POGODA) 
            {
                if (MASZ_SAMOCHOD) 
                {
                    $this->jazdaSamochodem();
                } else if (MASZ_PIENIADZE && NA_TRASIE_AUTOBUSU)
                {
                    $this->jazdaAutobusem();
                } else
                {
                    $this->jazdaRowerem();
                }
            } else
            {
                if ($odleglosc < MAKSYMALNA_ODLEGLOSC_SPACERU && !SPIESZYSZ_SIE)
                {
                    $this->spacer();
                } else
                {
                    if (MASZ_SAMOCHOD)
                    {
                        $this->jazdaSamochodem();
                    } else if (MASZ_PIENIADZE && NA_TRASIE_AUTOBUSU)
                    {
                        $this->jazdaAutobusem();
                    } else
                    {
                        $this->jazdaRowerem();
                    }
                }
            }
        } else
        {
            if (ZLA_POGODA)
            {
                print "Błąd: Burza<br/>";
            } else if ($odleglosc < MAKSYMALNA_ODLEGLOSC_SPACERU)
            {
                $this->spacer();
            } else
            {
                print "Błąd: Zbyt daleko na spacer<br/>";
            }
        }
        
        print "Czas podróży: " . date ( "i:s", $this->czas );
    }

    private function czyMamyOpcje(){
        $ma_opcje = false;
        if (MASZ_SAMOCHOD || (MASZ_PIENIADZE && NA_TRASIE_AUTOBUSU) || MASZ_ROWER) {
            $ma_opcje = true;
        }
        
        return $ma_opcje;
    }

    private function jazdaSamochodem()
    {
        //jazda samochodem
        $this->czas += OPOZNIENIE_SAMOCHODU;
        while ( abs ( $this->start->x - $this->cel->x ) > KROK_SAMOCHOD || abs ( $this->start->y - $this->cel->y ) > KROK_SAMOCHOD ) {
            $this->start->x += (KROK_SAMOCHOD * cos ( $this->kat_w_radianach ));
            $this->start->y += (KROK_SAMOCHOD * sin ( $this->kat_w_radianach ));
            ++ $this->czas;
            print "jazda samochodem... aktualna pozycja to (" .
            round ( $this->start->x, 2 ) . ", " .
            round ( $this->start->y, 2 ) . ")<br/>\n";
        }
        print "Dotarłeś do celu samochodem.<br/>";
    }
    
    private function jazdaAutobusem()
    {
        //jazda autobusem
        $this->czas += OPOZNIENIE_AUTOBUSU;
        while ( abs ( $this->start->x - $this->cel->x ) > KROK_AUTOBUS || abs ( $this->start->y - $this->cel->y ) > KROK_AUTOBUS ) {
            $this->start->x += (KROK_AUTOBUS * cos ( $this->kat_w_radianach ));
            $this->start->y += (KROK_AUTOBUS * sin ( $this->kat_w_radianach ));
            ++ $this->czas;
            print "jazda autobusem... aktualna pozycja to (" .
            round ( $this->start->x, 2 ) . ", " .
            round ( $this->start->y, 2 ) . ")<br/>\n";
        }
        print "Dotarłeś do celu autobusem.<br/>";
    }
    
    private function jazdaRowerem()
    {
        //jazda rowerem
        while ( abs ( $this->start->x - $this->cel->x ) > KROK_ROWER || abs ( $this->start->y - $this->cel->y ) > KROK_ROWER ) {
            $this->start->x += (KROK_ROWER * cos ( $this->kat_w_radianach ));
            $this->start->y += (KROK_ROWER * sin ( $this->kat_w_radianach ));
            ++ $this->czas;
            print "jazda rowerem... aktualna pozycja to (" .
            round ( $this->start->x, 2 ) . ", " .
            round ( $this->start->y, 2 ) . ")<br/>\n";
        }
        print "Dotarłeś do celu rowerem.<br/>";
    }
    
    private function spacer()
    {
        //spacer
        while ( abs ( $this->start->x - $this->cel->x ) > KROK_SPACER || abs ( $this->start->y - $this->cel->y ) > KROK_SPACER ) {
            $this->start->x += (KROK_SPACER * cos ( $this->kat_w_radianach ));
            $this->start->y += (KROK_SPACER * sin ( $this->kat_w_radianach ));
            ++ $this->czas;
            print "spacer... aktualna pozycja to (" .
            round ( $this->start->x, 2 ) . ", " .
            round ( $this->start->y, 2 ) . ")<br/>\n";
        }
        print "Dotarłeś do celu spacerem.<br/>";
    }
}
?>
