<?php               
/* ADOdb */
require_once ('adodb5/adodb.inc.php');
require_once ('adodb5/adodb-exceptions.inc.php');
$ADODB_FETCH_MODE = ADODB_FETCH_NUM;
$db = ADONewConnection("postgres8");
$naglowki = array("ID", "AUTOR", "DATA PUBLIKACJI", "URL", "ARTYKUŁ");

/* moduły PEAR zostały wykorzystane dla uproszczenia */
require_once ('HTML/Form.php');
require_once ('HTML/Table.php');
$attrs = array("rules" => "rows,cols", "border" => "3", "align" => "center");
$tabela = new HTML_Table($attrs);
$tabela->setAutoGrow(true);

/* ustawienie nagłówka tabeli */
foreach (range(0, count($naglowki) - 1) as $i) {
    $tabela->setHeaderContents(0, $i, $naglowki[$i]);
}

/* pobranie dokumentu z bazy danych */
$zapytanie = "select * from artykuly where id_dokumentu=?";
$wyszukanie = null;
if (!empty($_POST['wyszukanie'])) {
    $wyszukanie = trim($_POST['wyszukanie']);
}

/* wyświetlenie prostego formularza, składającego się z jednego pola tekstowego */
echo "<center><h2>Wyszukiwanie Sphinx</h2></center><hr>";
$formularz = new HTML_Form($_SERVER['PHP_SELF'], "POST");
$formularz->addTextarea("wyszukanie", 'Szukana fraza:', $wyszukanie, 65, 12);
$formularz->addSubmit("submit", "Szukaj");
$formularz->display();

/* stop - nie ma czego szukać */
if (empty($wyszukanie)) exit;
try {
    $db->Connect("localhost", "postgres", "test", "mgogala");
    $stmt = $db->Prepare($zapytanie);
    
    /* połączenie z procesem "searchd" */
    $cl = new SphinxClient();
    $cl->SetServer("localhost", 9312);
    
    /* ustawienie trybu rozszerzonego wyszukiwania */
    $cl->SetMatchMode(SPH_MATCH_EXTENDED2);
    
    /* rezultaty zostaną posortowane według daty */
    $cl->SetSortMode(SPH_SORT_ATTR_DESC, "data_publikacji");
    
    /* uruchomienie wyszukiwania i sprawdzenie problemów */
    $wynik = $cl->Query($wyszukanie);
    if ($wynik === false) {
        throw new Exception($cl->GetLastError());
    } else {
        if ($cl->GetLastWarning()) {
            echo "UWAGA: " . $cl->GetLastWarning() . "<br>";
        }
    }
    /* pobranie wyników i wykorzystanie ich w zapytaniu do bazy */
    foreach ($wynik["matches"] as $doc => $docinfo) {
        $rs = $db->Execute($stmt, array($doc));
        $wiersz = $rs->FetchRow();
        /* dodanie rezultatu zapytania do tabeli wynikowej */
        $tabela->addRow($wiersz);
    }
    /* wyświetlenie rezultatów */
    echo $tabela->toHTML();   
}
catch(Exception $e) {
    die($e->getMessage());
}
