<?php
error_reporting ( E_ALL );
//stałe
define ( 'KROK_SPACER', 0.25 ); //kroki o długości ćwierci metra
define ( 'KROK_ROWER', 3.00 ); //kroki o długości trzech metrów
define ( 'KROK_AUTOBUS', 30.00 ); //kroki autobusu
define ( 'OPOZNIENIE_AUTOBUSU', 300 ); //czas oczekiwania na autobus
define ( 'KROK_SAMOCHOD', 50.00 ); //kroki samochodu
define ( 'OPOZNIENIE_SAMOCHODU', 20 ); //czas rozpędzania samochodu
define ( 'MASZ_SAMOCHOD', true );
define ( 'MASZ_PIENIADZE', true );
define ( 'SPIESZYSZ_SIE', true );
define ( 'NA_TRASIE_AUTOBUSU', true );
define ( 'MASZ_ROWER', false );
define ( 'ZLA_POGODA', false );
define ( 'MAKSYMALNA_ODLEGLOSC_SPACERU', 2500 );

class Lokalizacja {
    public $x = 0;
    public $y = 0;
    
    public function __construct($x, $y) {
        $this->x = $x;
        $this->y = $y;
    }
    public function toString() {
        return "(" . round ( $this->x, 2 ) . ", " . round ( $this->y, 2 ) . ")";
    }
}

function podroz(Lokalizacja $start, Lokalizacja $cel) {
    //obliczenie wektora kierunku
    $odleglosc_y = $cel->y - $start->y;
    $odleglosc_x = $cel->x - $start->x;
    $kat = null;
    
    if ($odleglosc_x) {
        if ($odleglosc_y) {
            $kat = atan($odleglosc_y / $odleglosc_x);
        } else {
            if ($odleglosc_x > 0) {
                $kat = 0.0; //w prawo
            } else {
                $kat = 180.0; //w lewo
            }
        }
    } else {
        if ($odleglosc_y) {
            if ($odleglosc_y < 0) {
                $kat = - 90.0; //w dół
            } else {
                $kat = 90.0; //w górę
            }
        }
    }
    $kat_w_radianach = deg2rad ( $kat );
    
    $odleglosc = 0.0;
    //obliczenie odległości w linii prostej
    if ($cel->y == $start->y) {
        $odleglosc = $cel->x - $start->x;
    } else if ($cel->x == $start->x) {
        $odleglosc = $cel->y - $start->y;
    } else {
        $odleglosc = sqrt ( ($odleglosc_x * $odleglosc_x) +
        ($odleglosc_y * $odleglosc_y) );
    }
    
    print "Podróż z " . $start->toString () . " do " . $cel->toString () . "<br/>\n";
    if (SPIESZYSZ_SIE) {
        print "<strong>Spieszysz się!</strong><br/>\n";
    }
    print "Odległość to " . $odleglosc . " pod kątem " . $kat . "<br/>";
         
    $czas = 0.0;
    
    $ma_opcje = false;
    if (MASZ_SAMOCHOD || (MASZ_PIENIADZE && NA_TRASIE_AUTOBUSU) || MASZ_ROWER) {
        $ma_opcje = true;
    }
    if ($ma_opcje) {
        if (ZLA_POGODA) {
            if (MASZ_SAMOCHOD) {
                //jazda samochodem
                while ( abs ( $start->x - $cel->x ) > KROK_SAMOCHOD || abs ( $start->y - $cel->y ) > KROK_SAMOCHOD ) {
                    $start->x += (KROK_SAMOCHOD * cos ( $kat_w_radianach ));
                    $start->y += (KROK_SAMOCHOD * sin ( $kat_w_radianach ));
                    ++ $czas;
                    print "jazda samochodem... aktualna pozycja to (" .
                    round ( $start->x, 2 ) . ", " .
                    round ( $start->y, 2 ) . ")<br/>\n";
                }
                print "Dotarłeś do celu samochodem.<br/>";
            } else if (MASZ_PIENIADZE && NA_TRASIE_AUTOBUSU) {
                //jazda autobusem
                while ( abs ( $start->x - $cel->x ) > KROK_AUTOBUS || abs ( $start->y - $cel->y ) > KROK_AUTOBUS ) {
                    $start->x += (KROK_AUTOBUS * cos ( $kat_w_radianach ));
                    $start->y += (KROK_AUTOBUS * sin ( $kat_w_radianach ));
                    ++ $czas;
                    print "jazda autobusem... aktualna pozycja to (" .
                    round ( $start->x, 2 ) . ", " .
                    round ( $start->y, 2 ) . ")<br/>\n";
                }
                print "Dotarłeś do celu autobusem.<br/>";
            } else {
                //jazda rowerem
                while ( abs ( $start->x - $cel->x ) > KROK_ROWER || abs ( $start->y - $cel->y ) > KROK_ROWER ) {
                    $start->x += (KROK_ROWER * cos ( $kat_w_radianach ));
                    $start->y += (KROK_ROWER * sin ( $kat_w_radianach ));
                    ++ $czas;
                    print "jazda rowerem... aktualna pozycja to (" .
                    round ( $start->x, 2 ) . ", " .
                    round ( $start->y, 2 ) . ")<br/>\n";
                }
                print "Dotarłeś do celu rowerem.<br/>";
            }
        } else {
            if ($odleglosc < MAKSYMALNA_ODLEGLOSC_SPACERU && ! SPIESZYSZ_SIE) { 
                //spacer
                while ( abs ( $start->x - $cel->x ) > KROK_SPACER || abs ( $start->y - $cel->y ) > KROK_SPACER ) {
                    $start->x += (KROK_SPACER * cos ( $kat_w_radianach ));
                    $start->y += (KROK_SPACER * sin ( $kat_w_radianach ));
                    ++ $czas;
                    print "spacer... aktualna pozycja to (" .
                    round ( $start->x, 2 ) . ", " .
                    round ( $start->y, 2 ) . ")<br/>\n";
                }
                print "Dotarłeś do celu spacerem.<br/>";
            } else {
                if (MASZ_SAMOCHOD) {
                    //jazda samochodem
                    $czas += OPOZNIENIE_SAMOCHODU;
                    while ( abs ( $start->x - $cel->x ) > KROK_SAMOCHOD || abs ( $start->y - $cel->y ) > KROK_SAMOCHOD ) {
                        $start->x += (KROK_SAMOCHOD * cos ( $kat_w_radianach ));
                        $start->y += (KROK_SAMOCHOD * sin ( $kat_w_radianach ));
                        ++ $czas;
                        print "jazda samochodem... aktualna pozycja to (" .
                        round ( $start->x, 2 ) . ", " .
                        round ( $start->y, 2 ) . ")<br/>\n";
                    }
                    print "Dotarłeś do celu samochodem.<br/>";
                } else if (MASZ_PIENIADZE && NA_TRASIE_AUTOBUSU) {
                    //jazda autobusem
                    $czas += OPOZNIENIE_AUTOBUSU;
                    while ( abs ( $start->x - $cel->x ) > KROK_AUTOBUS || abs ( $start->y - $cel->y ) > KROK_AUTOBUS ) {
                        $start->x += (KROK_AUTOBUS * cos ( $kat_w_radianach ));
                        $start->y += (KROK_AUTOBUS * sin ( $kat_w_radianach ));
                        ++ $czas;
                        print "jazda autobusem... aktualna pozycja to (" .
                        round ( $start->x, 2 ) . ", " .
                        round ( $start->y, 2 ) . ")<br/>\n";
                    }
                    print "Dotarłeś do celu autobusem.<br/>";
                } else {
                    //jazda rowerem
                    while ( abs ( $start->x - $cel->x ) > KROK_ROWER ||
                        abs ( $start->y - $cel->y ) > KROK_ROWER ) {
                        $start->x += (KROK_ROWER * cos ( $kat_w_radianach ));
                        $start->y += (KROK_ROWER * sin ( $kat_w_radianach ));
                        ++ $czas;
                        print "jazda rowerem... aktualna pozycja to (" .
                        round ( $start->x, 2 ) . ", " .
                        round ( $start->y, 2 ) . ")<br/>\n";
                    }
                    print "Dotarłeś do celu rowerem<br/>";
                }
            }
        }
    } else {
        if (ZLA_POGODA) {
            print "Błąd: Burza<br/>";
        } else if ($odleglosc < MAKSYMALNA_ODLEGLOSC_SPACERU) {
            //spacer
            while ( abs ( $start->x - $cel->x ) > KROK_SPACER || abs ( $start->y - $cel->y ) > KROK_SPACER ) {
                $start->x += (KROK_SPACER * cos ( $kat_w_radianach ));
                $start->y += (KROK_SPACER * sin ( $kat_w_radianach ));
                ++ $czas;
                print "spacer... aktualna pozycja to (" .
                round ( $start->x, 2 ) . ", " .
                round ( $start->y, 2 ) . ")<br/>\n";
            }
            print "Dotarłeś do celu spacerem.br/>";
        } else {
            print "Błąd: Zbyt daleko na spacer<br/>";
        }
    }
    print "Czas podróży: " . date ( "i:s", $czas );
}
//przykładowe wykorzystanie
//podroz ( new Lokalizacja ( 1, 3 ), new Lokalizacja ( 4, 10 ) );
?>
