<?php
$zapytanie = "select p.pNazwisko,p.stanowisko,d.dNazwa,d.lokalizacja
              from prac p join dzial d on(d.dzialId=p.dzialId)";
$nazwyKolumn = array();
$formaty = array();
$liczbaKolumn = 0;
try {
    $db = new SQLite3("test.sqlite");
    $res = $db->query($zapytanie);
    if ($db->lastErrorCode() != 0) {
        throw new Exception($db->lastErrorMsg());
    }
    // pobranie liczby kolumn
    $liczbaKolumn = $res->numColumns();
    // Dla każdej kolumny zdefiniuj format w zależności od jej typu.
    foreach (range(0, $liczbaKolumn - 1) as $i) {
        $nazwyKolumn[$i] = $res->columnName($i);
        switch ($res->columnType($i)) {
            case SQLITE3_TEXT:
                $formaty[$i] = "% 12s";
            break;
            case SQLITE3_INTEGER:
                $formaty[$i] = "% 12d";
            break;
            case SQLITE3_NULL:
                $formaty[$i] = "% 12s";
            break;
            default:
                $formaty[$i] = "%12s";
        }
    }
    // wyświetlenie nazw kolumn po konwersji na kapitaliki
    foreach ($nazwyKolumn as $c) {
    printf("%12s", strtoupper($c));
    }
    // wypisanie podkreślenia nagłówka  
    printf("\n% '-48s\n", "-");
    // wypisanie danych wiersza
    while ($wiersz = $res->fetchArray(SQLITE3_NUM)) {
        foreach (range(0, $liczbaKolumn - 1) as $i) {
            printf($formaty[$i], $wiersz[$i]);
        }
        print "\n";
    }
}
catch(Exception $e) {
    print "Wyjątek:\n";
    die($e->getMessage() . "\n");
}
?>
